/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Boot;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.nautilus.Nautilus;
import com.arizotaz.core.reqs.MultipartUtility;
import com.arizotaz.core.tools.ThreadManager;
import java.io.File;
import java.util.List;

public class Analytics {
    public static int thread;
    static String logName;
    static String logLocation;

    static {
        logName = "";
        logLocation = "";
    }

    public static void Setup() {
        new File(String.valueOf(Options.appData) + "Logs/").mkdir();
        logName = "log_" + System.currentTimeMillis() + ".txt";
        logLocation = String.valueOf(Options.appData) + "Logs/" + logName;
        String header = "";
        header = String.valueOf(header) + "Arizotaz Java Logging System (AJLS)\n";
        header = String.valueOf(header) + "Started " + System.currentTimeMillis() + "\n";
        header = String.valueOf(header) + "Application " + Options.applicationID + "\n";
        header = String.valueOf(header) + "OS " + System.getProperty("os.name") + "\n";
        header = String.valueOf(header) + "Using Nautilus: ";
        header = !Nautilus.applicationID.equals("") ? String.valueOf(header) + "true" : String.valueOf(header) + "false";
        header = String.valueOf(header) + "\n";
        header = String.valueOf(header) + "----------------------------\n\n";
        System.out.print(header);
        thread = ThreadManager.Create("Analytics Loop Thread", new Thread(new Runnable(){

            @Override
            public void run() {
                while (Boot.run) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                Analytics.Log("\n\n----------------------------");
            }
        }));
        ThreadManager.Start(thread);
    }

    public static void LogNautilus() {
        String header = "";
        if (Nautilus.accountData != null) {
            try {
                header = String.valueOf(header) + "----User Account Info----\n";
                for (String key : Nautilus.accountData.keySet()) {
                    header = String.valueOf(header) + key + ": " + Nautilus.accountData.get((Object)key) + "\n";
                }
                header = String.valueOf(header) + "-------------------------\n";
            }
            catch (Exception e) {
                header = String.valueOf(header) + e.toString();
            }
        }
        Analytics.Log(header);
    }

    public static void Log(Object ob) {
        System.out.println(ob);
    }

    public static void Warn(Object ob) {
        System.out.print("[WARNING] ");
        System.out.println(ob);
    }

    public static void Error(Object ob) {
        System.out.print("---[ERROR] => ");
        System.out.println(ob);
    }

    public static void SendLog(File log) {
        if (Nautilus.applicationID == null || Nautilus.applicationID.equals("")) {
            System.out.println("No Applicaion ID was Present");
            return;
        }
        try {
            File file = log;
            String charset = "UTF-8";
            String requestURL = "https://lumonality.com/nautilus/trident/application/log/";
            MultipartUtility multipart = new MultipartUtility(requestURL, charset);
            multipart.addHeaderField("User-Agent", "LumonalityCore_" + Nautilus.applicationID);
            multipart.addHeaderField("Test-Header", "Header-Value");
            multipart.addFormField("applicationID", Nautilus.applicationID);
            String account = "Unknown";
            try {
                if (Nautilus.accountData != null && Nautilus.accountData.get((Object)"accountID") != null) {
                    account = Nautilus.accountData.get((Object)"accountID").toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            multipart.addFormField("applicationVersion", Options.applicationVersion);
            multipart.addFormField("accountID", account);
            multipart.addFormField("coreVersion", Core.Version());
            multipart.addFormField("debugMode", String.valueOf(Boot.DebugMode()));
            multipart.addFilePart("data", file);
            String result = "";
            List<String> response = multipart.finish();
            for (String line : response) {
                result = String.valueOf(result) + line;
            }
            System.out.println("Sent With agent ArizotazCore_" + Nautilus.applicationID);
            System.out.println("Sent AppID " + Nautilus.applicationID);
            System.out.println("Sent Version " + Options.applicationVersion);
            System.out.println("Sent AccountID " + account);
            System.out.println("Sent Core Version " + Core.Version());
            System.out.println(result);
        }
        catch (Exception e) {
            System.out.println("Failed to send log");
        }
    }
}

