/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.ConsoleOutputCapturer;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.struc.Time;
import com.arizotaz.core.tools.Fs;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.ui.UIElement;
import com.arizotaz.core.window.CrashWindow;
import com.arizotaz.core.window.WindowManager;
import java.io.File;
import java.util.HashSet;

public class Boot {
    private static long startTime = 0L;
    private static long coreTime = 0L;
    private static long bootTime = 0L;
    public static boolean run = true;
    private static boolean debugMode = false;
    private static Exception crash;
    public static String closeMessage;
    public static int exitCode;
    private static String[] arguments;
    private static boolean gc;
    private int frames = 0;

    static {
        closeMessage = "";
        exitCode = 0;
        gc = false;
    }

    public static String[] Args() {
        return arguments;
    }

    public static void main(String[] args) {
        arguments = args;
        if (System.getProperty("debug") != null && (System.getProperty("debug").equals("true") || System.getProperty("debug").equals(""))) {
            debugMode = true;
        }
        System.out.println("%CORE^LOOPUP% V" + Core.Version());
        ConsoleOutputCapturer console = new ConsoleOutputCapturer();
        console.start();
        if (debugMode) {
            System.out.println("{%DEBUGMODEACTIVE%}");
        }
        new Boot();
        String message = "Closing";
        if (WindowManager.window != null) {
            WindowManager.window.setTitle("Closing Threads");
        }
        System.out.println("Closing Threads");
        Text.font = "textAtlas_01";
        RenderObjects.useMaps = false;
        while (!ThreadManager.Closed()) {
            if (WindowManager.window != null) {
                RenderObjects.render = true;
                try {
                    message = "Closing " + ThreadManager.AliveThreads() + " Threads";
                    WindowManager.window.setTitle(message);
                    WindowManager.window.loop(false);
                    Options.setTranslate(0.0f, 0.0f);
                    RenderObjects.setColor(0.0f, 0.0f, 0.0f);
                    RenderObjects.drawRect(WindowManager.window.Width() / 2, WindowManager.window.Height() / 2, WindowManager.window.Width(), WindowManager.window.Width(), 0.0f);
                    float indexY = WindowManager.window.Height() - 10;
                    Text.setColor(255);
                    Text.render(message, 10.0f, indexY, 24.0f, 1000, 0);
                    indexY -= 25.0f;
                    Text.render(closeMessage, 10.0f, -34.0f, 18.0f, 1000, 0);
                    indexY -= 30.0f;
                    String[] threads = ThreadManager.Names();
                    int i = 0;
                    while (i < threads.length) {
                        Text.render(threads[i], 10.0f, indexY, 18.0f, 1000, 0);
                        indexY -= 20.0f;
                        ++i;
                    }
                    WindowManager.window.Swap();
                    Thread.sleep(66L);
                }
                catch (InterruptedException indexY) {}
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        com.arizotaz.Boot.Exit();
        if (WindowManager.window != null) {
            WindowManager.window.quit();
        }
        Analytics.LogNautilus();
        Analytics.Log("App Closed Successfully");
        String log = console.stop();
        File logFile = new File(Analytics.logLocation);
        Fs.WriteText(logFile, log);
        if (crash != null) {
            new CrashWindow(String.valueOf(log) + "\n\nSaved Log file to " + Analytics.logLocation);
        }
        if (crash != null && exitCode == 0) {
            exitCode = 1;
        }
        System.out.println("Exited with Code: " + exitCode);
        System.exit(exitCode);
    }

    public Boot() {
        try {
            startTime = System.currentTimeMillis();
            Analytics.Log("Starting Analytics Engine");
            Analytics.Setup();
            Analytics.Log("Analytics Engine Started");
            Analytics.Log("Loading Config");
            com.arizotaz.Boot.Config();
            System.out.println("Starting Core");
            Core.Start();
            if (Core.InstanceAlreadyOpened()) {
                Fs.WriteText(new File(String.valueOf(Options.appData) + "openInstance"), "yes");
                Analytics.Log("An instance Of this application already exists");
                System.exit(0);
            }
            System.out.println("Starting Application Boot Script");
            com.arizotaz.Boot.Start();
            System.out.println("Finalizing Core");
            Core.Load();
            coreTime = System.currentTimeMillis() - startTime;
            Analytics.Log("Sytem took " + coreTime + "ms to load");
            System.out.println("Running Loop\n");
            while (run) {
                try {
                    this.AppProcess();
                }
                catch (Exception e) {
                    crash = e;
                    crash.printStackTrace();
                    run = false;
                    if (WindowManager.window == null) continue;
                    WindowManager.window.quit();
                    WindowManager.window = null;
                }
            }
            if (crash == null) {
                System.out.println("Running Close Script");
                com.arizotaz.Boot.Close();
            }
        }
        catch (Exception e) {
            if (WindowManager.window != null) {
                WindowManager.window.quit();
            }
            System.out.println("Failed to start Engine");
            e.printStackTrace();
            run = false;
            crash = e;
        }
    }

    public static void GC() {
        gc = true;
    }

    private void AppProcess() throws Exception {
        RenderObjects.drawTime = 0L;
        Time.update();
        Core.process();
        WindowManager.window.loop(!RenderObjects.useMaps);
        if (!WindowManager.window.BootMenuActive() && WindowManager.window.bootDone && !WindowManager.window.booted) {
            bootTime = System.currentTimeMillis() - startTime;
            Analytics.Log("Boot took " + bootTime + "ms to load");
            WindowManager.window.booted = true;
            Analytics.Log("----------Done----------\n\n\n");
        }
        UIElement.Process();
        if (RenderObjects.useMaps) {
            long time = System.currentTimeMillis();
            this.ProcessMaps();
            RenderObjects.mapsProcessTime = System.currentTimeMillis() - time;
        } else {
            RenderObjects.render = true;
        }
        if (crash != null) {
            throw crash;
        }
        if (gc) {
            System.out.println("[GC] Garbage Collection");
            gc = !gc;
            System.gc();
        }
    }

    private void ProcessMaps() {
        if ((long)RenderObjects.map.hashCode() != RenderObjects.mapsLastState || RenderObjects.resetMap) {
            RenderObjects.resetMap = false;
            RenderObjects.mapsLastState = RenderObjects.map.hashCode();
            RenderObjects.renderTimer = 0.0f;
            RenderObjects.render = true;
            WindowManager.window._setFPS = WindowManager.window.maxFPS;
            WindowManager.window.Swap();
            this.frames = 0;
        } else if (RenderObjects.renderTimer < RenderObjects.mapsIdleTime) {
            RenderObjects.renderTimer += Time.deltaTime / 1000.0f;
            int show = 0;
            if (RenderObjects.showPaused && RenderObjects.mapsIdleTime - RenderObjects.renderTimer < 1000.0f / Options.fps / 100.0f + 0.05f) {
                show = 255;
            }
            WindowManager.window.Swap();
            this.frames = 0;
        } else if (this.frames < 7) {
            ++this.frames;
            RenderObjects.render = true;
            WindowManager.window.Swap();
        } else {
            RenderObjects.render = false;
            WindowManager.window._setFPS = RenderObjects.mapsFPS;
        }
        RenderObjects.map = new HashSet();
    }

    public static boolean DebugMode() {
        return debugMode;
    }

    public static void Crash(Exception e) {
        crash = e;
    }

    public static Exception Crash() {
        return crash;
    }

    public static long StartTime() {
        return startTime;
    }

    public static long BootTime() {
        return bootTime;
    }

    public static long CoreTime() {
        return coreTime;
    }

    public static long AliveTime() {
        return System.currentTimeMillis() - startTime;
    }
}

