/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

public class ConsoleOutputCapturer {
    private ByteArrayOutputStream baos;
    private PrintStream previous;
    private PrintStream errors;
    private boolean capturing;

    public void start() {
        if (this.capturing) {
            return;
        }
        this.capturing = true;
        this.previous = System.out;
        this.errors = System.err;
        this.baos = new ByteArrayOutputStream();
        OutputStreamCombiner outputStreamCombiner = new OutputStreamCombiner(Arrays.asList(this.previous, this.baos));
        PrintStream custom = new PrintStream(outputStreamCombiner);
        System.setOut(custom);
        System.setErr(custom);
    }

    public String stop() {
        if (!this.capturing) {
            return "";
        }
        System.setOut(this.previous);
        System.setErr(this.errors);
        String capturedValue = this.baos.toString();
        this.baos = null;
        this.previous = null;
        this.capturing = false;
        return capturedValue;
    }

    private static class OutputStreamCombiner
    extends OutputStream {
        private List<OutputStream> outputStreams;

        public OutputStreamCombiner(List<OutputStream> outputStreams) {
            this.outputStreams = outputStreams;
        }

        @Override
        public void write(int b) throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.write(b);
            }
        }

        @Override
        public void flush() throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.flush();
            }
        }

        @Override
        public void close() throws IOException {
            for (OutputStream os : this.outputStreams) {
                os.close();
            }
        }
    }
}

