/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.Boot;
import com.arizotaz.core.Engine;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.Texture;
import com.arizotaz.core.menus.Debug;
import com.arizotaz.core.menus.Link;
import com.arizotaz.core.menus.Menu;
import com.arizotaz.core.menus.Message;
import com.arizotaz.core.menus.ParseXLInstaller;
import com.arizotaz.core.reqs.TextureLoad;
import com.arizotaz.core.struc.Font;
import com.arizotaz.core.struc.Time;
import com.arizotaz.core.tools.Download;
import com.arizotaz.core.tools.Fs;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.Mouse;
import com.arizotaz.core.window.WindowManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Core {
    public static boolean showDebug = false;
    public static boolean debugMenu = false;
    public static boolean lastDebugMenuState = false;
    public static boolean onlyAllowOneInstance = false;
    public static String status = "";
    private static String platform = "java";
    private static ArrayList<String> bannerMessages = new ArrayList();
    private static float bannerMessagesTimer = 0.0f;
    private static String version = "C_V1.B25.R1.TX";
    private static Font font = new Font("DefaultFont");
    private static boolean lightMode = true;
    private static boolean openInstance = false;
    private static long lastInstanceWrite = 0L;
    public static int ui = 0;
    public static int lastUI = -1;
    public static Debug debug = new Debug();
    public static Link toURL = new Link();
    public static Message messagePrompt = new Message();
    public static Menu ParseXLInstaller = new ParseXLInstaller();

    public static void FindJava() {
        String jaCom = "java";
        switch (Core.Platform()) {
            case "windows": {
                if (new File(String.valueOf(Options.startLocation) + "jre/bin/javaw.exe").exists()) {
                    jaCom = new File(String.valueOf(Options.startLocation) + "jre/bin/javaw.exe").getAbsolutePath();
                    break;
                }
                try {
                    String jsonLibrary = Fs.ReadText(new File(String.valueOf(Options.container) + "portal/library.json"));
                    JSONParser parser = new JSONParser();
                    JSONObject libraryDat = (JSONObject)parser.parse(jsonLibrary);
                    JSONObject apps = (JSONObject)libraryDat.get((Object)"apps");
                    JSONObject JRE = (JSONObject)apps.get((Object)"JRE");
                    String appLocation = JRE.get((Object)"appFolder").toString();
                    if (appLocation == null || appLocation.equals("")) {
                        throw new Exception("JRE not installed via Portal");
                    }
                    if (!appLocation.endsWith("/") && !appLocation.endsWith("\\")) {
                        appLocation = String.valueOf(appLocation) + "/";
                    }
                    if (!new File(String.valueOf(appLocation) + "bin/javaw.exe").exists()) {
                        throw new Exception("Could not find javaw.exe");
                    }
                    jaCom = new File(String.valueOf(appLocation) + "bin/javaw.exe").getAbsolutePath();
                    Analytics.Warn("Found installed JRE in Lumonality Launcher");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (!new File(String.valueOf(Options.container) + "portal/app/JRE/bin/javaw.exe").exists()) break;
                    jaCom = new File(String.valueOf(Options.container) + "portal/app/JRE/bin/javaw.exe").getAbsolutePath();
                }
                break;
            }
            case "mac": {
                if (!new File(String.valueOf(Options.container) + "portal/app/JRE/bin/java").exists()) break;
                jaCom = new File(String.valueOf(Options.container) + "portal/app/JRE/bin/java").getAbsolutePath();
            }
        }
        if (jaCom.equals("java")) {
            Analytics.Warn("Could not find an instance of JAVA, defaulting to public JRE");
        } else {
            Analytics.Warn("Using JRE found at " + jaCom);
        }
        Options.javaCommand = jaCom;
    }

    public static void Start() {
        Options.startLocation = new File("").getAbsolutePath();
        if (!Options.startLocation.endsWith("/") && !Options.startLocation.endsWith("\\")) {
            Options.startLocation = String.valueOf(Options.startLocation) + "/";
        }
        status = "Creating Platform Properties";
        if (System.getProperty("os.name").startsWith("Windows")) {
            platform = "windows";
            Options.homePATH = String.valueOf(System.getProperty("user.home")) + "/AppData/Roaming/Lumonality/";
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            platform = "mac";
            Options.homePATH = String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/Lumonality/";
        } else {
            platform = "linux";
            Options.homePATH = String.valueOf(System.getProperty("user.home")) + "/Lumonality/";
        }
        Analytics.Log("Creating Data Folders");
        status = "Creating Directories";
        Options.container = Options.homePATH;
        Options.homePATH = String.valueOf(Options.homePATH) + "arizotazcore/";
        Options.downloads = String.valueOf(Options.homePATH) + "download/";
        Options.temp = String.valueOf(Options.homePATH) + "cache/";
        Options.cache = String.valueOf(Options.homePATH) + "cache/";
        Options.appData = String.valueOf(Options.homePATH) + "appData/" + Options.applicationID + "/";
        Options.jarData = String.valueOf(Options.startLocation);
        Texture.textureCache = String.valueOf(Options.startLocation);
        Core.FindJava();
        Core.SetParms();
        File path = new File(Options.downloads);
        if (!path.exists()) {
            path.mkdirs();
        }
        if (!(path = new File(Options.cache)).exists()) {
            path.mkdirs();
        }
        if (!(path = new File(Options.temp)).exists()) {
            path.mkdirs();
        }
        if (!(path = new File(Options.appData)).exists()) {
            path.mkdirs();
        }
        if (!(path = new File(Options.jarData)).exists()) {
            path.mkdirs();
        }
        if (!(path = new File(Texture.textureCache)).exists()) {
            path.mkdirs();
        }
        Analytics.Log("Data Folders Done");
    }

    public static void Load() {
        if (Options.lwjgl) {
            status = "Loading Textures";
            Core.essentialTextures();
        }
        status = "Core Loaded";
        System.out.println("Core Done");
        System.out.println("Arizotaz Core V" + Core.Version());
    }

    public static boolean InstanceAlreadyOpened() {
        long time;
        return onlyAllowOneInstance && new File(String.valueOf(Options.appData) + "appTime").exists() && (time = Long.parseLong(Fs.ReadText(new File(String.valueOf(Options.appData) + "appTime")))) + 2000L > System.currentTimeMillis();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkCache() {
        status = "Checking Cache";
        File cacheFile = new File(String.valueOf(Options.cache) + "stamp.dat");
        if (!cacheFile.exists()) {
            Fs.WriteText(cacheFile, String.valueOf(System.currentTimeMillis()));
            return;
        }
        String filetime = Fs.ReadText(cacheFile);
        System.out.println("time " + filetime);
        try {
            long time = Long.parseLong(filetime);
            if (time + 172800000L >= System.currentTimeMillis()) return;
            Core.ClearCache();
            while (Download.filesDownloaded < Download.filesToDownload) {
                if (TextureLoad.needLoaded.size() <= 0) {
                    return;
                }
                status = "Loading " + (TextureLoad.needLoaded.size() + (Download.filesToDownload - Download.filesDownloaded)) + " Assets";
                Thread.sleep(100L);
            }
            return;
        }
        catch (Exception e) {
            Fs.WriteText(cacheFile, String.valueOf(System.currentTimeMillis()));
            return;
        }
    }

    public static void ClearCache() {
        File cacheFile = new File(String.valueOf(Options.cache) + "stamp.dat");
        Analytics.Warn("Clearing Application Cache Folder");
        status = "Clearing Cache";
        Fs.deleteFolder(new File(Options.cache));
        new File(Options.cache).mkdir();
        Fs.WriteText(cacheFile, String.valueOf(System.currentTimeMillis()));
        Core.essentialTextures();
    }

    public static void essentialTextures() {
        Analytics.Warn("Loading Essential Textures");
        Text.font = "textAtlas_01";
        Texture.loadToMap("textAtlas_01", "com/arizotaz/core/assets/font.png", false);
        Texture.loadToMap("lumonality_logo", "com/arizotaz/core/assets/lumonality_logo.png", true);
        Texture.loadToMap("lumonality", "com/arizotaz/core/assets/lumonality_light.png", true);
        Texture.loadToMap("none", "com/arizotaz/core/assets/empty.png", false);
        Texture.loadToMap("core_asset_loading", "com/arizotaz/core/assets/loading.png", false);
    }

    public static void loadAssets() throws InterruptedException {
        status = "Loading Assets";
        Analytics.Log("Loading Assets Textures");
        Texture.AddToLoadList("cursor", "com/arizotaz/core/assets/cursor.png", false);
        Texture.AddToLoadList("pointer", "com/arizotaz/core/assets/cursor_pointer.png", false);
        Texture.AddToLoadList("button", "com/arizotaz/core/assets/button.png", false);
        Texture.AddToLoadList("hint", "com/arizotaz/core/assets/hint.png", false);
        Texture.AddToLoadList("checkbox_checked", "com/arizotaz/core/assets/checkbox_checked.png", false);
        Texture.AddToLoadList("checkbox_unchecked", "com/arizotaz/core/assets/checkbox_unchecked.png", false);
        Thread.sleep(500L);
        while (Download.filesDownloaded < Download.filesToDownload && TextureLoad.needLoaded.size() > 0) {
            status = "Loading " + (TextureLoad.needLoaded.size() + (Download.filesToDownload - Download.filesDownloaded)) + " Assets";
            Thread.sleep(500L);
        }
        status = "Importing Default Font...";
        Analytics.Log("Importing Default Font...");
        font.importLocal("com/arizotaz/core/assets/font.json");
    }

    public static boolean OpenInstance() {
        return openInstance;
    }

    public static void process() throws Exception {
        Mouse.clicked = false;
        Mouse.aclicked = false;
        if (Mouse.left) {
            Mouse._click = 2;
        }
        if (Mouse._click == 1 && Mouse.__click == 2) {
            Mouse.clicked = true;
            Mouse.aclicked = true;
        }
        Mouse.__click = Mouse._click;
        if (Mouse._click > 0) {
            --Mouse._click;
        }
        if (Download._DownloadedFiles < Download._RequiredDownload) {
            Download.inProgress = true;
            Download.progress = Download.totalBytes / Download.requiredBytes;
        } else {
            Download.inProgress = false;
            if (Download.filesToDownload != 0) {
                Download.resetStats();
            }
        }
        openInstance = false;
        if (onlyAllowOneInstance && System.currentTimeMillis() - lastInstanceWrite > 500L) {
            lastInstanceWrite = System.currentTimeMillis();
            Fs.WriteText(new File(String.valueOf(Options.appData) + "appTime"), String.valueOf(System.currentTimeMillis()));
            if (new File(String.valueOf(Options.appData) + "openInstance").exists()) {
                Fs.deleteFolder(new File(String.valueOf(Options.appData) + "openInstance"));
                openInstance = true;
            }
        }
    }

    public static void renderOverlay() {
        boolean lastBlockButtons = Engine.blockButtons;
        boolean lastBlockInput = Engine.blockInput;
        boolean lastBlockInputField = Engine.blockInputField;
        boolean lastBlockMouse = Engine.blockMouse;
        Engine.a();
        Options.setTranslate(Options.widthOfScreen / 2.0f, Options.heightOfScreen / 2.0f);
        if (Download.inProgress) {
            RenderObjects.setColor(0.0f);
            RenderObjects.drawRect(0.0f, Options.heightOfScreen / 2.0f - 60.0f, 600.0f, 80.0f, 0.0f);
            Text.setColor(255);
            Text.render("Downloading", 0.0f, Options.heightOfScreen / 2.0f - 60.0f + 12.0f, 24.0f, 1000, Text.center);
            RenderObjects.setColor(0.0f);
            RenderObjects.drawRect(0.0f, Options.heightOfScreen / 2.0f - 60.0f - 12.0f, 400.0f, 10.0f, 0.0f);
            RenderObjects.setColor(255.0f);
            RenderObjects.drawRect(-200.0f + 200.0f * Tools.clampVar(Download.progress, 0.0f, 1.0f), Options.heightOfScreen / 2.0f - 60.0f - 12.0f, Tools.clampVar(Download.progress, 0.0f, 1.0f) * 400.0f, 10.0f, 0.0f);
        }
        if (bannerMessages.size() > 0) {
            RenderObjects.setColor(0.0f, 0.0f, 0.0f);
            RenderObjects.drawRect(0.0f, Options.heightOfScreen / 2.0f - 60.0f, 600.0f, 100.0f, 0.0f);
            Text.setColor(255);
            Text.render("Message", 0.0f, Options.heightOfScreen / 2.0f - 60.0f + 12.0f, 24.0f, 1000, Text.center);
            Text.render(bannerMessages.get(0), 0.0f, Options.heightOfScreen / 2.0f - 60.0f - 12.0f, 12.0f, 40, Text.center);
            if (bannerMessagesTimer > 0.0f) {
                bannerMessagesTimer -= Time.deltaTime / 1000.0f;
            } else {
                bannerMessages.remove(0);
                bannerMessagesTimer = 5.0f;
            }
        }
        if (Options.lwjgl) {
            try {
                if (TextureLoad.needLoaded.size() > 0) {
                    String id = TextureLoad.needLoaded.get(0);
                    System.out.println("Loading Texture " + id);
                    Texture texture = Texture.textures.get(id);
                    if (texture != null) {
                        texture.LoadTexture();
                        RenderObjects.renderTimer = 0.0f;
                        RenderObjects.map = new HashSet();
                        System.out.println("Loaded Texture " + texture.ID());
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(5000L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                Boot.GC();
                            }
                        }).start();
                    }
                    TextureLoad.needLoaded.remove(0);
                }
                while (TextureLoad.needDestroyed.size() > 0) {
                    String texID = TextureLoad.needDestroyed.get(0);
                    System.out.println("Destroying " + texID);
                    Texture tex = Texture.textures.get(texID);
                    if (tex != null) {
                        tex.GLDestroy();
                        System.out.println("Destroyed " + texID);
                        Texture.textures.remove(texID);
                    } else {
                        System.out.println("Could not destroy " + texID + " texture");
                    }
                    TextureLoad.needDestroyed.remove(0);
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            Boot.GC();
                        }
                    }).start();
                }
            }
            catch (ConcurrentModificationException texID) {
                // empty catch block
            }
            if (KeyboardInput.isPressed(300)) {
                WindowManager.window.toggleFullscreen();
                System.out.println("WINDOW_FULLSCREEN:" + WindowManager.window.fullscreen);
            }
        }
        if (KeyboardInput.isPressed(297)) {
            boolean bl = lightMode = !lightMode;
        }
        if (KeyboardInput.isPressed(292)) {
            boolean bl = debugMenu = !debugMenu;
        }
        if (KeyboardInput.isPressed(293)) {
            boolean bl = RenderObjects.useMaps = !RenderObjects.useMaps;
            if (!RenderObjects.useMaps) {
                RenderObjects.render = true;
            }
            System.out.println("RENDER_MAPS:" + RenderObjects.useMaps);
        }
        boolean newMenu = false;
        if (lastUI != ui) {
            lastUI = ui;
            newMenu = true;
        }
        switch (ui) {
            case 1: {
                debugMenu = true;
                ui = 0;
                break;
            }
            case 2: {
                if (newMenu) {
                    toURL.Wake();
                }
                toURL.Render();
                break;
            }
            case 3: {
                if (newMenu) {
                    messagePrompt.Wake();
                }
                messagePrompt.Render();
                break;
            }
            case 10: {
                if (newMenu) {
                    ParseXLInstaller.Wake();
                }
                ParseXLInstaller.Render();
            }
        }
        if (debugMenu) {
            if (!lastDebugMenuState) {
                debug.Wake();
            }
            debug.Render();
            RenderObjects.debug_reset();
        }
        lastDebugMenuState = debugMenu;
        Mouse.render();
        Engine.blockButtons = lastBlockButtons;
        Engine.blockInput = lastBlockInput;
        Engine.blockInputField = lastBlockInputField;
        Engine.blockMouse = lastBlockMouse;
    }

    public static void banner(String text) {
        boolean add = true;
        int i = 0;
        while (i < bannerMessages.size()) {
            if (bannerMessages.get(i).equals(text)) {
                add = false;
            }
            ++i;
        }
        if (add) {
            bannerMessagesTimer = 5.0f;
            bannerMessages.add(text);
        }
    }

    public static void ForceOneInstance(boolean val) {
        onlyAllowOneInstance = val;
    }

    public static String Version() {
        return version;
    }

    public static boolean LightMode() {
        return lightMode;
    }

    public static int LightModeInt() {
        return lightMode ? 0 : 1;
    }

    public static boolean LightMode(boolean value) {
        lightMode = value;
        return Core.LightMode();
    }

    public static void Crash(String reason) {
        Boot.Crash(new Exception(reason));
    }

    public static Font DefaultFont() {
        return font;
    }

    public static String Platform() {
        return platform;
    }

    public static void SetParms() {
        Options.desktop = String.valueOf(System.getProperty("user.home")) + "Desktop/";
        Options.documents = String.valueOf(System.getProperty("user.home")) + "Documents/";
        if (platform.equals("windows")) {
            String line;
            String result;
            BufferedReader reader;
            Process process;
            Analytics.Log("Finding Desktop Folder for Windows");
            String command = "powershell -command \"[Environment]::GetFolderPath('\"Desktop\"')\"";
            try {
                process = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                result = "";
                while ((line = reader.readLine()) != null) {
                    result = String.valueOf(result) + line;
                }
                reader.close();
                Options.desktop = String.valueOf(result) + "/";
                Analytics.Log("Found Desktop Folder");
            }
            catch (IOException e) {
                e.printStackTrace();
                Analytics.Warn("Desktop Folder could not be located, defaulting to primitive type");
            }
            Analytics.Log("Finding Documents Folder for Windows");
            command = "powershell -command \"[Environment]::GetFolderPath('\"MyDocuments\"')\"";
            try {
                process = Runtime.getRuntime().exec(command);
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                result = "";
                while ((line = reader.readLine()) != null) {
                    result = String.valueOf(result) + line;
                }
                reader.close();
                Options.documents = String.valueOf(result) + "/";
                Analytics.Log("Found Documents Folder");
            }
            catch (IOException e) {
                e.printStackTrace();
                Analytics.Warn("Documents Folder could not be located, defaulting to primitive type");
            }
        }
    }
}

