/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Options;
import com.arizotaz.core.Texture;
import java.util.HashSet;
import org.lwjgl.opengl.GL11;

public class RenderObjects {
    public static boolean renderTextureInCenter = false;
    public static boolean allowStretch = false;
    public static String lastImage = "";
    public static int mapsFPS = 60;
    public static float mapsIdleTime = 0.0f;
    public static boolean useMaps = true;
    public static boolean showPaused = false;
    public static boolean render = true;
    public static long mapsProcessTime = 0L;
    public static boolean resetMap = false;
    public static HashSet<String> map = new HashSet();
    public static long mapsLastState = 0L;
    public static float renderTimer = 0.0f;
    public static long drawTime = 0L;
    public static long renderTime = 0L;
    public static int debug_objects = 0;
    public static int debug_binds = 0;

    public static void ForceMapUpdate() {
        resetMap = true;
    }

    public static void debug_reset() {
        debug_objects = 0;
        debug_binds = 0;
    }

    public static void setColor(float l) {
        RenderObjects.setColor(l, l, l);
    }

    public static void setColor(float l, float a) {
        RenderObjects.setColor(l, l, l, a);
    }

    public static void setColor(float r, float g, float b) {
        RenderObjects.setColor(r, g, b, 255.0f);
    }

    public static void setColor(float r, float g, float b, float a) {
        float _r = r / 255.0f;
        float _g = g / 255.0f;
        float _b = b / 255.0f;
        float _a = a / 255.0f;
        GL11.glColor4d((double)_r, (double)_g, (double)_b, (double)_a);
    }

    public static void drawRect(float x, float y, float width, float height, float rot) {
        long startTime = System.nanoTime();
        if (x + Options.translateX - width > Options.widthOfScreen) {
            return;
        }
        if (x + Options.translateX + width < 0.0f) {
            return;
        }
        if (y + Options.translateY - height > Options.heightOfScreen) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (useMaps) {
            map.add("rect(" + (x + Options.translateX + Options.translateXOff) + "," + (y + Options.translateY + Options.translateYOff) + "," + width + "," + height + "," + rot + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += Options.translateX + Options.translateXOff), (float)(y += Options.translateY + Options.translateYOff), (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
        GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
        GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
        GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
        GL11.glEnd();
        GL11.glPopMatrix();
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }

    public static void drawImage(String textureID, float x, float y, float width, float height, float rot) {
        long startTime = System.nanoTime();
        if (x + Options.translateX - width > Options.widthOfScreen) {
            return;
        }
        if (x + Options.translateX + width < 0.0f) {
            return;
        }
        if (y + Options.translateY - height > Options.heightOfScreen) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (!Texture.textures.containsKey(textureID)) {
            if (Texture.InLoadList(textureID)) {
                Texture.LoadFromList(textureID);
            } else {
                textureID = "air";
            }
        }
        if (textureID.equals("air")) {
            return;
        }
        if (!Texture.textures.get((Object)textureID).loaded) {
            textureID = "core_asset_loading";
        }
        if (useMaps) {
            map.add("image(" + textureID + "," + (x + Options.translateX + Options.translateXOff) + "," + (y + Options.translateY + Options.translateYOff) + "," + width + "," + height + "," + rot + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += Options.translateX + Options.translateXOff), (float)(y += Options.translateY + Options.translateYOff), (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        float imgRatio = 1.0f;
        try {
            if (textureID != lastImage) {
                lastImage = textureID;
                ++debug_binds;
                try {
                    Texture.textures.get(textureID).bind();
                    imgRatio = (float)Texture.textures.get((Object)textureID).width / (float)Texture.textures.get((Object)textureID).height;
                }
                catch (Exception e) {
                    Texture.textures.get("textAtlas_01").bind();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!renderTextureInCenter) {
            if (!allowStretch) {
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)0.0f, (float)(height / width));
                GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
                GL11.glTexCoord2f((float)1.0f, (float)(height / width));
                GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
                GL11.glEnd();
            } else {
                GL11.glBegin((int)7);
                GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
                GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
                GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
                GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
                GL11.glEnd();
            }
        } else {
            GL11.glBegin((int)7);
            float val = height * imgRatio / 2.0f / width;
            GL11.glTexCoord2f((float)0.0f, (float)(0.5f + val));
            GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
            GL11.glTexCoord2f((float)0.0f, (float)(0.5f - val));
            GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)(0.5f - val));
            GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
            GL11.glTexCoord2f((float)1.0f, (float)(0.5f + val));
            GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
            GL11.glEnd();
        }
        GL11.glPopMatrix();
        renderTextureInCenter = false;
        allowStretch = false;
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }

    public static void drawImageFromSheet(String textureID, float x, float y, float width, float height, float imageX, float imageY, float spritesInRow, int sheetSize, float rot) {
        long startTime = System.nanoTime();
        if (x + Options.translateX - width > Options.widthOfScreen) {
            return;
        }
        if (x + Options.translateX + width < 0.0f) {
            return;
        }
        if (y + Options.translateY - height > Options.heightOfScreen) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (!Texture.textures.containsKey(textureID)) {
            if (Texture.InLoadList(textureID)) {
                Texture.LoadFromList(textureID);
            } else {
                textureID = "air";
            }
        }
        if (textureID.equals("air")) {
            return;
        }
        if (!Texture.textures.get((Object)textureID).loaded) {
            textureID = "core_asset_loading";
        }
        if (useMaps) {
            map.add("imageFromSheet(" + textureID + "," + (x + Options.translateX + Options.translateXOff) + "," + (y + Options.translateY + Options.translateYOff) + "," + width + "," + height + "," + imageX + "," + imageY + "," + rot + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += Options.translateX + Options.translateXOff), (float)(y += Options.translateY + Options.translateYOff), (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        try {
            if (textureID != lastImage) {
                lastImage = textureID;
                ++debug_binds;
                try {
                    Texture.textures.get(textureID).bind();
                }
                catch (Exception e) {
                    Texture.textures.get("textAtlas_01").bind();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(imageX / (float)sheetSize), (float)((imageY + (float)sheetSize / spritesInRow) / (float)sheetSize));
        GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
        GL11.glTexCoord2f((float)(imageX / (float)sheetSize), (float)(imageY / (float)sheetSize));
        GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
        GL11.glTexCoord2f((float)((imageX + (float)sheetSize / spritesInRow - 0.1f) / (float)sheetSize), (float)(imageY / (float)sheetSize));
        GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
        GL11.glTexCoord2f((float)((imageX + (float)sheetSize / spritesInRow - 0.1f) / (float)sheetSize), (float)((imageY + (float)sheetSize / spritesInRow) / (float)sheetSize));
        GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
        GL11.glEnd();
        GL11.glPopMatrix();
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }

    public static void drawImageFromSheet(String textureID, float x, float y, float width, float height, float imageX, float imageY, float imageW, float imageH, int widthbyheight, float rot) {
        long startTime = System.nanoTime();
        if (x + Options.translateX - width > Options.widthOfScreen) {
            return;
        }
        if (x + Options.translateX + width < 0.0f) {
            return;
        }
        if (y + Options.translateY - height > Options.heightOfScreen) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (y + Options.translateY + height < 0.0f) {
            return;
        }
        if (!Texture.textures.containsKey(textureID)) {
            if (Texture.InLoadList(textureID)) {
                Texture.LoadFromList(textureID);
            } else {
                textureID = "air";
            }
        }
        if (textureID.equals("air")) {
            return;
        }
        if (!Texture.textures.get((Object)textureID).loaded) {
            textureID = "core_asset_loading";
        }
        if (useMaps) {
            map.add("imageFromSheet(" + textureID + "," + (x + Options.translateX + Options.translateXOff) + "," + (y + Options.translateY + Options.translateYOff) + "," + width + "," + height + "," + imageX + "," + imageY + "," + imageW + "," + imageH + "," + rot + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(x += Options.translateX + Options.translateXOff), (float)(y += Options.translateY + Options.translateYOff), (float)0.0f);
        GL11.glRotatef((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
        float sheetSizeW = 128.0f;
        float sheetSizeH = 128.0f;
        try {
            if (textureID != lastImage) {
                lastImage = textureID;
                ++debug_binds;
                try {
                    Texture.textures.get(textureID).bind();
                    sheetSizeW = Texture.textures.get((Object)textureID).width;
                    sheetSizeH = Texture.textures.get((Object)textureID).height;
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            sheetSizeW = Texture.textures.get((Object)textureID).width;
            sheetSizeH = Texture.textures.get((Object)textureID).height;
        }
        catch (Exception exception) {
            // empty catch block
        }
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)(imageX / sheetSizeW), (float)((imageY + imageH) / sheetSizeH));
        GL11.glVertex2f((float)(-width / 2.0f), (float)(-height / 2.0f));
        GL11.glTexCoord2f((float)(imageX / sheetSizeW), (float)(imageY / sheetSizeH));
        GL11.glVertex2f((float)(-width / 2.0f), (float)(height / 2.0f));
        GL11.glTexCoord2f((float)((imageX + imageW) / sheetSizeW), (float)(imageY / sheetSizeH));
        GL11.glVertex2f((float)(width / 2.0f), (float)(height / 2.0f));
        GL11.glTexCoord2f((float)((imageX + imageW) / sheetSizeW), (float)((imageY + imageH) / sheetSizeH));
        GL11.glVertex2f((float)(width / 2.0f), (float)(-height / 2.0f));
        GL11.glEnd();
        GL11.glPopMatrix();
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }

    public static void drawRoundedRect(double x, double y, double z, double width, double height, double offset, int arcSeg) {
        long startTime = System.nanoTime();
        if (x + (double)Options.translateX - width > (double)Options.widthOfScreen) {
            return;
        }
        if (x + (double)Options.translateX + width < 0.0) {
            return;
        }
        if (y + (double)Options.translateY - height > (double)Options.heightOfScreen) {
            return;
        }
        if (y + (double)Options.translateY + height < 0.0) {
            return;
        }
        if (useMaps) {
            map.add("roundRect(" + (x + (double)Options.translateX + (double)Options.translateXOff) + "," + (y + (double)Options.translateY + (double)Options.translateYOff) + "," + width + "," + height + "," + offset + "," + arcSeg + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        double wsize = width / 2.0;
        double hsize = height / 2.0;
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glPopMatrix();
        RenderObjects.drawQuadFan(x += (double)(Options.translateX + Options.translateXOff), y += (double)(Options.translateY + Options.translateYOff), z, wsize - offset, hsize - offset);
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y + hsize - offset), (double)z);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y + hsize - offset), (double)z);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y + hsize), (double)z);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y + hsize), (double)z);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y - hsize), (double)z);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y - hsize), (double)z);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)(x - wsize), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x - wsize + offset), (double)(y + hsize - offset), (double)z);
        GL11.glVertex3d((double)(x - wsize), (double)(y + hsize - offset), (double)z);
        GL11.glEnd();
        GL11.glBegin((int)7);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x + wsize), (double)(y - hsize + offset), (double)z);
        GL11.glVertex3d((double)(x + wsize), (double)(y + hsize - offset), (double)z);
        GL11.glVertex3d((double)(x + wsize - offset), (double)(y + hsize - offset), (double)z);
        GL11.glEnd();
        RenderObjects.drawPie(x + wsize - offset, y + hsize - offset, z, offset, 0.0, 90.0, arcSeg);
        RenderObjects.drawPie(x - wsize + offset, y + hsize - offset, z, offset, 90.0, 180.0, arcSeg);
        RenderObjects.drawPie(x - wsize + offset, y - hsize + offset, z, offset, 180.0, 270.0, arcSeg);
        RenderObjects.drawPie(x + wsize - offset, y - hsize + offset, z, offset, 270.0, 360.0, arcSeg);
        GL11.glPopMatrix();
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }

    public static void drawQuadFan(double x, double y, double z, double w, double h) {
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glBegin((int)6);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        GL11.glVertex3d((double)(x - w), (double)(y - h), (double)z);
        GL11.glVertex3d((double)(x + w), (double)(y - h), (double)z);
        GL11.glVertex3d((double)(x + w), (double)(y + h), (double)z);
        GL11.glVertex3d((double)(x - w), (double)(y + h), (double)z);
        GL11.glVertex3d((double)(x - w), (double)(y - h), (double)z);
        GL11.glEnd();
    }

    public static void drawPie(double x, double y, double z, double r, double start, double end, int seg) {
        if (!render) {
            return;
        }
        ++debug_objects;
        double ang = (end - start) / (double)seg;
        GL11.glBegin((int)6);
        GL11.glVertex3d((double)x, (double)y, (double)z);
        int i = 0;
        while (i <= seg) {
            double rx = r * Math.cos((start + ang * (double)i) * 3.1416 / 180.0);
            double ry = r * Math.sin((start + ang * (double)i) * 3.1416 / 180.0);
            GL11.glVertex3d((double)(x + rx), (double)(y + ry), (double)z);
            ++i;
        }
        GL11.glEnd();
    }

    public static void drawLine(float x, float y, float x2, float y2, float weight) {
        long startTime = System.nanoTime();
        if (useMaps) {
            map.add("line(" + (x + Options.translateX + Options.translateXOff) + "," + (y + Options.translateY + Options.translateYOff) + "," + x2 + "," + y2 + ",ss" + weight + ")");
        }
        if (!render) {
            return;
        }
        ++debug_objects;
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(Options.translateX + Options.translateXOff), (float)(Options.translateY + Options.translateYOff), (float)0.0f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glLineWidth((float)weight);
        GL11.glBegin((int)3);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)x2, (float)y2);
        GL11.glEnd();
        GL11.glPopMatrix();
        long endTime = System.nanoTime();
        drawTime += endTime - startTime;
    }
}

