/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.nautilus.Nautilus;
import com.arizotaz.core.struc.Font;
import com.arizotaz.core.tools.Download;
import com.arizotaz.core.tools.Web;
import com.arizotaz.core.ui.InvisButton;
import java.io.File;

public class Text {
    public static float defaultCharacterSpacing = 0.05f;
    public static float defaultFontSize = 18.0f;
    public static float defaultLineSpacing = 1.0f;
    public static float defaultSpaceWidth = 1.0f;
    public static int defaulthHAlign = 1;
    public static int defaultVAlign = 1;
    public static Font defaultFont = null;
    public static int dr = 0;
    public static int dg = 0;
    public static int db = 0;
    public static int da = 255;
    String text = "";
    boolean textChanged = true;
    String renderText = "";
    Font textFont;
    float fontSize = defaultFontSize;
    float textureWidth = 0.0f;
    float textureHeight = 0.0f;
    float width = 0.0f;
    float height = 0.0f;
    float maxWidth = 1280.0f;
    int halign = defaulthHAlign;
    int valign = defaultVAlign;
    int tr = 0;
    int tg = 0;
    int tb = 0;
    int ta = 255;
    public static int left = 0;
    public static int center = 1;
    public static int right = 2;
    float characterSpacing = defaultCharacterSpacing;
    float lineSpacing = defaultLineSpacing;
    float spaceWidth = defaultSpaceWidth;
    boolean wrapText = true;
    int selectedIndex = -1;
    public static String font = "textAtlas_01";
    public static boolean doBackground = false;
    public static boolean invisBackground = false;
    public static int r = 0;
    public static int g = 0;
    public static int b = 0;
    public static int a = 255;

    public static void SetDefaultColor(int r, int g, int b, int a) {
        dr = r;
        dg = g;
        db = b;
        da = a;
    }

    public static void SetDefaultColor(int r, int g, int b) {
        Text.SetDefaultColor(r, g, b, 255);
    }

    public static void SetDefaultColor(int l, int a) {
        Text.SetDefaultColor(l, l, l, a);
    }

    public static void SetDefaultColor(int l) {
        Text.SetDefaultColor(l, l, l);
    }

    public Text(String text) {
        this.textFont = defaultFont != null ? defaultFont : Core.DefaultFont();
        this.tr = dr;
        this.tg = dg;
        this.tb = db;
        this.ta = da;
        this.SetText(text);
        this.Set();
    }

    private void Set() {
        this.textureWidth = this.textFont.Width();
        this.textureHeight = this.textFont.Height();
        this.renderText = this.ProcessString(this.text);
        this.width = 0.0f;
        this.height = 0.0f;
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        String[] words = this.renderText.split(" ");
        int w = 0;
        while (w < words.length) {
            if (this.wrapText && xIndex + this.GetStringLength(words[w]) + this.spaceWidth * this.fontSize > this.maxWidth) {
                if (xIndex > this.width) {
                    this.width = xIndex;
                }
                xIndex = 0.0f;
                yIndex -= this.fontSize * this.lineSpacing;
            }
            char[] chars = words[w].toCharArray();
            int i = 0;
            while (i < chars.length) {
                Font.Char charObj;
                if (chars[i] == '\n') {
                    if (this.wrapText) {
                        if (xIndex > this.width) {
                            this.width = xIndex;
                        }
                        xIndex = 0.0f;
                        yIndex -= this.fontSize * this.lineSpacing;
                    } else {
                        xIndex += this.spaceWidth * this.fontSize;
                    }
                }
                if (chars[i] == '\t') {
                    xIndex += this.spaceWidth * this.fontSize;
                }
                if ((charObj = this.textFont.getChar(chars[i])) != null) {
                    float charHeight = (float)charObj.height() / this.textFont.LargestCharHeight() * this.fontSize;
                    float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
                    xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
                    xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
                }
                ++i;
            }
            if (words.length - 1 != w) {
                xIndex += this.spaceWidth * this.fontSize;
            }
            ++w;
        }
        if (xIndex > this.width) {
            this.width = xIndex;
        }
        if (this.width == 0.0f) {
            this.width = xIndex;
        }
        this.height = -yIndex + this.fontSize * this.lineSpacing;
        this.textChanged = false;
    }

    public void Render(float x, float y) {
        this.selectedIndex = -1;
        if (this.textChanged) {
            this.Set();
        }
        if (this.renderText.equals("")) {
            return;
        }
        float lastTransX = Options.translateX;
        float lastTransY = Options.translateY;
        Options.translate(x, y);
        if (this.halign == 1) {
            Options.translate(-this.width / 2.0f, 0.0f);
        }
        if (this.halign == 2) {
            Options.translate(-this.width, 0.0f);
        }
        if (this.valign == 1) {
            Options.translate(0.0f, this.height / 2.0f);
        }
        if (this.valign == 2) {
            Options.translate(0.0f, this.height);
        }
        if (Core.debugMenu) {
            RenderObjects.setColor(255.0f, 100.0f, 100.0f);
            RenderObjects.drawRect(this.width / 2.0f, -this.height / 2.0f, this.width, this.height, 0.0f);
            RenderObjects.setColor(155.0f, 255.0f, 155.0f);
            RenderObjects.drawRect(this.maxWidth / 2.0f, -this.height / 2.0f, this.maxWidth, this.height, 0.0f);
        }
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        int arrayIndex = 0;
        String[] words = this.renderText.split(" ");
        int w = 0;
        while (w < words.length) {
            if (this.wrapText && xIndex + this.GetStringLength(words[w]) + this.spaceWidth * this.fontSize > this.maxWidth) {
                if (xIndex > this.width) {
                    this.width = xIndex;
                }
                xIndex = 0.0f;
                yIndex -= this.fontSize * this.lineSpacing;
            }
            char[] chars = words[w].toCharArray();
            int i = 0;
            while (i < chars.length) {
                Font.Char charObj;
                if (chars[i] == '\n') {
                    if (this.wrapText) {
                        if (xIndex > this.width) {
                            this.width = xIndex;
                        }
                        xIndex = 0.0f;
                        yIndex -= this.fontSize * this.lineSpacing;
                    } else {
                        xIndex += this.spaceWidth * this.fontSize;
                    }
                }
                if (chars[i] == '\t') {
                    xIndex += this.spaceWidth * this.fontSize;
                }
                if ((charObj = this.textFont.getChar(chars[i])) != null) {
                    float charHeight = (float)charObj.height() / this.textFont.LargestCharHeight() * this.fontSize;
                    float charDept = (float)(charObj.originY() - charObj.height()) / this.textFont.LargestCharHeight() * this.fontSize;
                    float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
                    RenderObjects.setColor(this.tr, this.tg, this.tb, this.ta);
                    RenderObjects.drawImageFromSheet(this.textFont.Texture(), xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing, yIndex - this.fontSize / 1.2f + charHeight / 2.0f + charDept, charWidth, charHeight, charObj.x(), charObj.y(), charObj.width(), charObj.height(), 1, 0.0f);
                    xIndex += charWidth / 2.0f + this.fontSize * this.characterSpacing;
                }
                ++arrayIndex;
                ++i;
            }
            ++arrayIndex;
            if (words.length - 1 != w) {
                xIndex += this.spaceWidth * this.fontSize;
            }
            ++w;
        }
        if (xIndex > this.width) {
            this.width = xIndex;
        }
        if (this.width == 0.0f) {
            this.width = xIndex;
        }
        this.height = -yIndex + this.fontSize * this.lineSpacing;
        Options.setTranslate(lastTransX, lastTransY);
    }

    public int GetSelectedIndex() {
        return this.selectedIndex;
    }

    public void Calculate() {
        this.Set();
    }

    public void AllowWrap(boolean val) {
        this.wrapText = val;
        this.textChanged = true;
    }

    public void SetText(String text) {
        this.text = text;
        this.textChanged = true;
    }

    public void SetFont(Font font) {
        this.textFont = font;
        this.textChanged = true;
    }

    public void FontSize(float font) {
        this.fontSize = font;
        this.textChanged = true;
    }

    public void MaxWidth(float max) {
        this.maxWidth = max;
        this.textChanged = true;
    }

    public void SetLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.textChanged = true;
    }

    public void SetSpaceWidth(float spaceWidth) {
        this.spaceWidth = spaceWidth;
        this.textChanged = true;
    }

    public void Align(int horizontal) {
        this.halign = horizontal;
    }

    public void Align(int horizontal, int vertical) {
        this.Align(horizontal);
        this.valign = vertical;
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public float GetSpaceWidth() {
        return this.spaceWidth;
    }

    public float GetLineHeight() {
        return this.lineSpacing;
    }

    public float GetFontSize() {
        return this.fontSize;
    }

    public void Color(int v) {
        this.Color(v, 255);
    }

    public void Color(int v, int a) {
        this.Color(v, v, v, a);
    }

    public void Color(int r, int b, int g) {
        this.Color(r, g, b, 255);
    }

    public void Color(int r, int b, int g, int a) {
        this.tr = r;
        this.tg = g;
        this.tb = b;
        this.ta = a;
    }

    private String ProcessString(String val) {
        String text = val;
        text = text.replaceAll("%version%", Options.applicationVersion);
        text = text.replaceAll("%appid%", Options.applicationID);
        text = text.replaceAll("%title%", Options.title);
        text = text.replaceAll("%fps%", String.valueOf(Options.fps));
        text = text.replaceAll("%aricore%", "Arizotaz Core v" + Core.Version());
        text = text.replaceAll("%aricoreversion%", Core.Version());
        text = text.replaceAll("%appdataloc%", new File(Options.appData).getAbsolutePath().replace("\\", "/"));
        text = text.replaceAll("%downloadprogress%", String.valueOf(String.valueOf(Math.round(Download.progress * 100.0f))) + "%");
        if (Nautilus.accountData != null) {
            text = Nautilus.accountData.get((Object)"displayname") != null ? text.replaceAll("%displayname%", Nautilus.accountData.get((Object)"displayname").toString()) : text.replaceAll("%displayname%", "User");
            text = Nautilus.accountData.get((Object)"username") != null ? text.replaceAll("%username%", Nautilus.accountData.get((Object)"username").toString()) : text.replaceAll("%username%", "Unknown User");
        }
        while (text.contains("%junk%")) {
            String setOfCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=[];,./!@#%^&*()_+{}|:<>?";
            int randomInt = (int)Math.round(Math.random() * (double)(setOfCharacters.length() - 1));
            text = text.replaceFirst("%junk%", String.valueOf(setOfCharacters.charAt(randomInt)));
        }
        return text;
    }

    public float GetStringLength(String val) {
        float result = 0.0f;
        char[] chars = val.toCharArray();
        int i = 0;
        while (i < chars.length) {
            Font.Char charObj;
            if (chars[i] == '\n') {
                if (this.wrapText) {
                    if (result > this.width) {
                        this.width = result;
                    }
                    result = 0.0f;
                    result -= this.fontSize * this.lineSpacing;
                } else {
                    result += this.spaceWidth * this.fontSize;
                }
            }
            if (chars[i] == '\t') {
                result += this.spaceWidth * this.fontSize;
            }
            if ((charObj = this.textFont.getChar(chars[i])) != null) {
                float charHeight = (float)charObj.height() / this.textFont.LargestCharHeight() * this.fontSize;
                float charWidth = charHeight / (float)charObj.height() * (float)charObj.width();
                result += charWidth / 2.0f + this.fontSize * this.characterSpacing;
                result += charWidth / 2.0f + this.fontSize * this.characterSpacing;
            }
            ++i;
        }
        return result;
    }

    public static void setColor(int v) {
        Text.setColor(v, v, v);
    }

    public static void setColor(int r, int g, int b) {
        Text.r = r;
        Text.g = g;
        Text.b = b;
        a = 255;
    }

    public static void setColor(int r, int g, int b, int a) {
        Text.setColor(r, g, b);
        Text.a = a;
    }

    public static void render(String text, float x, float y, float fontSize, int maxWidth, int position) {
        text = text.replaceAll("%version%", Options.applicationVersion);
        text = text.replaceAll("%appid%", Options.applicationID);
        text = text.replaceAll("%title%", Options.title);
        if (Nautilus.accountData != null) {
            text = Nautilus.accountData.get((Object)"displayname") != null ? text.replaceAll("%displayname%", Nautilus.accountData.get((Object)"displayname").toString()) : text.replaceAll("%displayname%", "User");
            text = Nautilus.accountData.get((Object)"username") != null ? text.replaceAll("%username%", Nautilus.accountData.get((Object)"username").toString()) : text.replaceAll("%username%", "Unknown User");
        }
        text = text.replaceAll("%fps%", String.valueOf(Options.fps));
        text = text.replaceAll("%aricore%", "Arizotaz Core v" + Core.Version());
        text = text.replaceAll("%aricoreversion%", Core.Version());
        text = text.replaceAll("%downloadprogress%", String.valueOf(String.valueOf(Math.round(Download.progress * 100.0f))) + "%");
        while (text.contains("%junk%")) {
            String setOfCharacters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz1234567890-=[];,./!@#%^&*()_+{}|:<>?";
            int randomInt = (int)Math.round(Math.random() * (double)(setOfCharacters.length() - 1));
            text = text.replaceFirst("%junk%", String.valueOf(setOfCharacters.charAt(randomInt)));
        }
        float xIndex = 0.0f;
        float yIndex = 0.0f;
        float length = 0.0f;
        char[] string = text.toCharArray();
        int i = 0;
        while (i < string.length) {
            float[] location = Text.getLocation(string[i]);
            if (length <= (float)maxWidth) {
                length += location[2];
            }
            ++i;
        }
        float xOffset = fontSize / 2.0f;
        float yOffset = 0.0f;
        if (position == 0) {
            yOffset -= fontSize / 2.0f;
        }
        if (position == 1) {
            xOffset -= length * fontSize / 2.0f;
        }
        if (position == 2) {
            xOffset -= length * fontSize;
        }
        text = text.replaceAll("\n", "\n ");
        String[] chunks = text.split(" ");
        int i2 = 0;
        while (i2 < chunks.length) {
            char[] letters = chunks[i2].toCharArray();
            float widthOfWord = 0.0f;
            int w = 0;
            while (w < letters.length) {
                float[] location = Text.getLocation(letters[w]);
                widthOfWord += location[2];
                ++w;
            }
            if (xIndex + widthOfWord >= (float)maxWidth) {
                xIndex = 0.0f;
                yIndex -= 1.0f;
            }
            boolean overFlow = false;
            if (xIndex + widthOfWord > (float)maxWidth) {
                overFlow = true;
            }
            String link = "";
            if (chunks[i2].startsWith("http://") || chunks[i2].startsWith("https://")) {
                link = chunks[i2];
            }
            if (doBackground) {
                float _xIndex = xIndex;
                int w2 = 0;
                while (w2 < letters.length) {
                    float[] location = Text.getLocation(letters[w2]);
                    RenderObjects.setColor(0.0f);
                    if (invisBackground) {
                        RenderObjects.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                    }
                    RenderObjects.drawRect(x + _xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize + 5.0f, fontSize + 5.0f, 0.0f);
                    RenderObjects.setColor(255.0f);
                    _xIndex += location[2];
                    ++w2;
                }
            }
            int w3 = 0;
            while (w3 < letters.length) {
                float[] location = Text.getLocation(letters[w3]);
                if (letters[w3] == String.valueOf("\n").toCharArray()[0] || letters[w3] == String.valueOf("\t").toCharArray()[0]) {
                    if (letters[w3] == String.valueOf("\n").toCharArray()[0]) {
                        xIndex = 0.0f;
                        yIndex -= 1.0f;
                    } else {
                        xIndex += 1.0f;
                    }
                } else {
                    if (link == "") {
                        RenderObjects.setColor(r, g, b, a);
                        if (overFlow) {
                            RenderObjects.setColor(r, g, b, a - 80);
                        }
                    } else {
                        RenderObjects.setColor(0.0f, 100.0f, 200.0f);
                    }
                    if (!overFlow) {
                        RenderObjects.drawImageFromSheet(font, x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize, location[0] * 8.0f, location[1] * 8.0f, 16.0f, 128, 0.0f);
                    } else if (xIndex < (float)(maxWidth - 2)) {
                        RenderObjects.drawImageFromSheet(font, x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize, location[0] * 8.0f, location[1] * 8.0f, 16.0f, 128, 0.0f);
                    } else if (xIndex >= (float)(maxWidth - 2) && xIndex < (float)maxWidth) {
                        location = Text.getLocation('.');
                        RenderObjects.drawImageFromSheet(font, x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize, location[0] * 8.0f, location[1] * 8.0f, 16.0f, 128, 0.0f);
                        xIndex = (float)((double)xIndex + 0.3);
                        RenderObjects.drawImageFromSheet(font, x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize, location[0] * 8.0f, location[1] * 8.0f, 16.0f, 128, 0.0f);
                        xIndex = (float)((double)xIndex + 0.3);
                        RenderObjects.drawImageFromSheet(font, x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize, location[0] * 8.0f, location[1] * 8.0f, 16.0f, 128, 0.0f);
                        xIndex += 10.0f;
                    }
                    if (link != "") {
                        InvisButton button = new InvisButton();
                        button.Set("", x + xIndex * fontSize + xOffset, y + yIndex * fontSize + yOffset, fontSize, fontSize);
                        button.Render();
                        if (button.IsClicked()) {
                            Web.open(chunks[i2]);
                        }
                    }
                    xIndex += location[2];
                }
                ++w3;
            }
            link = "";
            if (xIndex != 0.0f) {
                xIndex += 1.0f;
            }
            ++i2;
        }
    }

    static float[] getLocation(char letter) {
        char tes;
        float[] location = new float[]{0.0f, 0.0f, 1.0f};
        char id = tes = letter;
        int id1 = id / 16;
        location[0] = id;
        location[1] = id1;
        switch (String.valueOf(letter)) {
            case "i": {
                location[2] = 0.5f;
                break;
            }
            case "l": {
                location[2] = 0.5f;
                break;
            }
            case ":": {
                location[2] = 0.5f;
                break;
            }
            case ".": {
                location[2] = 0.5f;
                break;
            }
            case "-": {
                location[2] = 0.8f;
            }
        }
        return location;
    }
}

