/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.Options;
import com.arizotaz.core.reqs.TextureLoad;
import com.arizotaz.core.reqs.URLTextureThread;
import com.arizotaz.core.tools.Fs;
import com.arizotaz.core.tools.ThreadManager;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;

public class Texture {
    public static String textureCache = "";
    private String coreID = "";
    private int id;
    public int width;
    public int height;
    public boolean ready = false;
    public boolean loaded = false;
    ByteBuffer pixels;
    boolean smooth = false;
    String fileName = "";
    boolean isOutsideOfClass = false;
    public static Map<String, Texture> textures = new HashMap<String, Texture>();
    private static HashMap<String, LoadEntry> dynLoadList = new HashMap();

    public Texture(String coreID, String fileName, boolean isOutsideOfClass, boolean filter) {
        this.coreID = coreID;
        this.fileName = fileName;
        this.isOutsideOfClass = isOutsideOfClass;
        this.smooth = filter;
    }

    public void Prepare() {
        try {
            BufferedImage bi = this.isOutsideOfClass ? ImageIO.read(new DataInputStream(new FileInputStream(this.fileName))) : ImageIO.read(Options.class.getResourceAsStream("/" + this.fileName));
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            int[] pixels_raw = new int[this.width * this.height * 4];
            pixels_raw = bi.getRGB(0, 0, this.width, this.height, null, 0, this.width);
            int _width = this.width;
            int _height = this.height;
            if (_width > _height) {
                _height = _width;
            }
            if (_height > _width) {
                _width = _height;
            }
            this.pixels = BufferUtils.createByteBuffer((int)(_width * _height * 4));
            int i = 0;
            while (i < _width) {
                int j = 0;
                while (j < _height) {
                    int pixel = 0;
                    try {
                        pixel = pixels_raw[i * _width + j];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.pixels.put((byte)(pixel >> 16 & 0xFF));
                    this.pixels.put((byte)(pixel >> 8 & 0xFF));
                    this.pixels.put((byte)(pixel & 0xFF));
                    this.pixels.put((byte)(pixel >> 24 & 0xFF));
                    ++j;
                }
                ++i;
            }
            ((Buffer)this.pixels).flip();
            this.ready = true;
            bi = null;
            pixels_raw = null;
            TextureLoad.needLoaded.add(this.coreID);
        }
        catch (Exception e) {
            e.printStackTrace();
            Texture.DestroyTexture(this.coreID);
        }
    }

    public void LoadTexture() {
        this.id = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)this.id);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5121, (ByteBuffer)this.pixels);
        if (this.smooth) {
            GL30.glGenerateMipmap((int)3553);
            GL11.glTexParameterf((int)3553, (int)10241, (float)9987.0f);
            GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
        } else {
            GL11.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GL11.glTexParameterf((int)3553, (int)10240, (float)9728.0f);
        }
        this.pixels = null;
        this.loaded = true;
    }

    public void bind() {
        GL11.glBindTexture((int)3553, (int)this.id);
    }

    public String ID() {
        return this.coreID;
    }

    public void Destroy() {
        TextureLoad.needDestroyed.add(this.coreID);
    }

    public void GLDestroy() {
        GL11.glDeleteTextures((int)this.id);
    }

    public static void loadToMap(String id, String path) {
        Texture.loadToMap(id, path, false);
    }

    public static void loadToMap(String id, String path, boolean filter) {
        Texture.loadToMap(id, path, false, false);
    }

    public static void loadToMap(String id, String path, boolean outsideJar, boolean filter) {
        if (outsideJar) {
            final Texture texture = new Texture(id, new File(path).getAbsoluteFile().toString(), outsideJar, filter);
            textures.put(id, texture);
            ThreadManager.Start(ThreadManager.Create(new Thread(new Runnable(){

                @Override
                public void run() {
                    texture.Prepare();
                }
            })));
        } else {
            Fs.ExportResource(path, String.valueOf(textureCache) + path.replaceAll("/", "."));
            path = String.valueOf(textureCache) + path.replaceAll("/", ".");
            final Texture texture = new Texture(id, path, true, filter);
            textures.put(id, texture);
            ThreadManager.Start(ThreadManager.Create(new Thread(new Runnable(){

                @Override
                public void run() {
                    texture.Prepare();
                }
            })));
        }
    }

    public static void urlToMap(String id, String path) {
        Texture.urlToMap(id, path, true);
    }

    public static void urlToMap(String id, String path, boolean filter) {
        Analytics.Log("Loading Texture from URL");
        try {
            String fileLoc = textureCache;
            fileLoc = String.valueOf(fileLoc) + "com.arizotaz.core.URLDOWNLOAD." + id + ".png";
            boolean needsDownload = false;
            if (!new File(fileLoc).exists()) {
                needsDownload = true;
            }
            if (!new File(String.valueOf(fileLoc) + ".texMeta").exists()) {
                needsDownload = true;
            } else {
                try {
                    long time = Long.parseLong(Fs.ReadText(new File(String.valueOf(fileLoc) + ".texMeta")));
                    if (System.currentTimeMillis() > time + 86400000L) {
                        needsDownload = true;
                    }
                }
                catch (Exception e) {
                    System.err.println("[TEXTURE ERROR] Failed to read meta data for downloaded file");
                    e.printStackTrace();
                    needsDownload = true;
                }
            }
            if (needsDownload) {
                Analytics.Log("Downloading Texture " + id);
                URLTextureThread r = new URLTextureThread(path, id, filter);
                ThreadManager.Start(ThreadManager.Create("TextureThread_LOAD_" + id, new Thread(r)));
            } else {
                Texture.AddToLoadList(id, fileLoc, true, filter);
            }
        }
        catch (Exception e) {
            Analytics.Log("Something went wrong loading " + id + " from url");
        }
    }

    public static void DestroyTexture(String id) {
        if (textures.get(id) != null) {
            textures.get(id).Destroy();
        }
    }

    public static boolean LoadFromList(String id) {
        if (Texture.InLoadList(id)) {
            LoadEntry entry = dynLoadList.get(id);
            Texture.loadToMap(entry.ID(), entry.FileLocation(), entry.OutsideJar(), entry.Filter());
            return true;
        }
        return false;
    }

    public static boolean InLoadList(String id) {
        return dynLoadList.containsKey(id);
    }

    public static void AddToLoadList(String id, String fileLocation) {
        Texture.AddToLoadList(id, fileLocation, false, false);
    }

    public static void AddToLoadList(String id, String fileLocation, boolean filter) {
        Texture.AddToLoadList(id, fileLocation, false, filter);
    }

    public static void AddToLoadList(String id, String fileLocation, boolean outsideJar, boolean filter) {
        dynLoadList.put(id, new LoadEntry(id, fileLocation, outsideJar, filter));
    }

    public static void UnloadListedTextures() {
        for (Map.Entry<String, LoadEntry> me : dynLoadList.entrySet()) {
            Texture.DestroyTexture(me.getKey());
        }
    }

    private static class LoadEntry {
        String id;
        String fileLocation;
        boolean outsideJar;
        boolean filter;

        private LoadEntry(String id, String fileLocation, boolean outsideJar, boolean filter) {
            this.id = id;
            this.fileLocation = fileLocation;
            this.outsideJar = outsideJar;
            this.filter = filter;
        }

        private String ID() {
            return this.id;
        }

        private String FileLocation() {
            return this.fileLocation;
        }

        private boolean OutsideJar() {
            return this.outsideJar;
        }

        private boolean Filter() {
            return this.filter;
        }
    }
}

