/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.graph;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.ui.InvisButton;
import com.arizotaz.core.window.Mouse;
import java.util.ArrayList;

public class TimeGraph {
    float width = 0.0f;
    float height = 0.0f;
    float x = 0.0f;
    float y = 0.0f;
    float maxColumns = 0.0f;
    float maxRows = 0.0f;
    String rowLabel = "";
    String columnLabel = "";
    ArrayList<Float> column = new ArrayList();
    ArrayList<Float> row = new ArrayList();
    ArrayList<String> labels = new ArrayList();
    ArrayList<int[]> color = new ArrayList();

    public TimeGraph(float maxColumns, float maxRows) {
        this.Start(maxColumns, maxRows, "", "");
    }

    public TimeGraph(float maxColumns, float maxRows, String rowLabel, String columnLabel) {
        this.Start(maxColumns, maxRows, rowLabel, columnLabel);
    }

    private void Start(float maxColumns, float maxRows, String rowLabel, String columnLabel) {
        this.maxRows = maxRows;
        this.maxColumns = maxColumns;
        this.rowLabel = rowLabel;
        this.columnLabel = columnLabel;
    }

    public void SetMaxes(float maxColumns, float maxRows) {
        this.maxRows = maxRows;
        this.maxColumns = maxColumns;
    }

    public void SetLabels(String row, String column) {
        this.rowLabel = row;
        this.columnLabel = column;
    }

    public void Clear() {
        this.column = new ArrayList();
        this.row = new ArrayList();
        this.labels = new ArrayList();
    }

    public void AddPoint(float x, float y) {
        this.AddPoint(x, y, "");
    }

    public void AddPoint(float x, float y, String label) {
        this.AddPoint(x, y, label, 255, 0, 0);
    }

    public void AddPoint(float x, float y, String label, int r, int g, int b) {
        this.column.add(Float.valueOf(x));
        this.row.add(Float.valueOf(y));
        this.labels.add(label);
        this.color.add(new int[]{r, g, b});
    }

    public void Render(float x, float y) {
        this.x = x;
        this.y = y;
        this.model();
    }

    public void SetSize(float width, float height) {
        this.width = width;
        this.height = height;
    }

    private void model() {
        float padding = Options.scl / 10.0f;
        Options.translate(this.x, this.y);
        RenderObjects.setColor(0.0f);
        RenderObjects.drawRect(0.0f, 0.0f, this.width, this.height, 0.0f);
        RenderObjects.setColor(200.0f);
        RenderObjects.drawRect(0.0f, 0.0f, this.width - padding, this.height - padding, 0.0f);
        try {
            float largestRow = this.maxRows;
            float largestColumn = this.maxColumns;
            int i = 0;
            while (i < this.column.size()) {
                float c = this.column.get(i).floatValue();
                float r = this.row.get(i).floatValue();
                if (this.maxRows <= 0.0f && r > largestRow) {
                    largestRow = r;
                }
                if (this.maxColumns <= 0.0f && c > largestColumn) {
                    largestColumn = c;
                }
                ++i;
            }
            if (this.maxRows <= 0.0f) {
                largestRow = (float)((double)largestRow + (double)largestRow * 0.05);
            }
            ArrayList<int[]> colorList = new ArrayList<int[]>();
            int i2 = 0;
            while (i2 < this.color.size()) {
                boolean found = false;
                int l = 0;
                while (l < colorList.size()) {
                    if (this.colorIsSame((int[])colorList.get(l), this.color.get(i2))) {
                        found = true;
                    }
                    ++l;
                }
                if (!found) {
                    colorList.add(this.color.get(i2));
                }
                ++i2;
            }
            this.RenderDetails(largestColumn, largestRow, padding);
            int l = 0;
            while (l < colorList.size()) {
                int colindex = 0;
                float lastX = 0.0f;
                float lastY = 0.0f;
                int i3 = 0;
                while (i3 < this.column.size()) {
                    int[] col = this.color.get(i3);
                    if (this.colorIsSame(col, (int[])colorList.get(l))) {
                        float c = this.column.get(i3).floatValue();
                        float r = this.row.get(i3).floatValue();
                        String label = this.labels.get(i3);
                        if (c <= largestColumn && r <= largestRow) {
                            float canvasWidth = this.width - padding;
                            float canvasHeight = this.height - padding;
                            float pointSize = this.width / 150.0f;
                            float pointX = c / largestColumn * canvasWidth - canvasWidth / 2.0f;
                            float pointY = r / largestRow * canvasHeight - canvasHeight / 2.0f;
                            RenderObjects.setColor(col[0], col[1], col[2]);
                            if (colindex > 0) {
                                RenderObjects.drawLine(lastX, lastY, pointX, pointY, pointSize / 2.0f);
                            }
                            RenderObjects.drawRect(pointX, pointY, pointSize, pointSize, 0.0f);
                            if (!label.equals("")) {
                                InvisButton button = new InvisButton();
                                button.Set("", pointX, pointY, 5.0f, 5.0f);
                                button.Render();
                                if (button.IsHovering()) {
                                    Mouse.hoverText = label;
                                }
                            }
                            lastX = pointX;
                            lastY = pointY;
                        }
                        ++colindex;
                    }
                    ++i3;
                }
                colindex = 0;
                ++l;
            }
        }
        catch (Exception e) {
            Text.setColor(255);
            Text.render("Error Creating Data", 0.0f, 0.0f, this.width / Options.scl, 1000, 1);
        }
        Options.translate(-this.x, -this.y);
    }

    private void RenderDetails(float largestColumn, float largestRow, float padding) {
        String t;
        Text text = new Text("");
        text.MaxWidth(this.width);
        text.Align(0, 0);
        text.Color(0);
        float interval = 0.1f;
        if (largestColumn > 1.0f) {
            interval = 0.5f;
        }
        if (largestColumn > 2.0f) {
            interval = 1.0f;
        }
        if (largestColumn > 10.0f) {
            interval = 2.0f;
        }
        if (largestColumn > 50.0f) {
            interval = 10.0f;
        }
        if (largestColumn > 100.0f) {
            interval = 20.0f;
        }
        if (largestColumn > 200.0f) {
            interval = 50.0f;
        }
        if (largestColumn > 500.0f) {
            interval = 100.0f;
        }
        if (largestColumn > 1000.0f) {
            interval = 500.0f;
        }
        if (largestColumn > 10000.0f) {
            interval = 1000.0f;
        }
        if (largestColumn > 100000.0f) {
            interval = 10000.0f;
        }
        text.FontSize(Tools.clampVar(largestColumn / interval, Options.scl / 4.0f, Options.scl));
        float i = 0.0f;
        while ((double)i <= Math.ceil(largestColumn)) {
            float indexX = -this.width / 2.0f + padding / 2.0f + i / largestColumn * (this.width - padding);
            RenderObjects.setColor(150.0f);
            RenderObjects.drawRect(indexX, 0.0f, 10.0f * (this.height / this.width), this.height, 0.0f);
            t = String.valueOf((float)Math.round(i * 1000.0f) / 1000.0f);
            if (t.endsWith(".0")) {
                t = t.substring(0, t.length() - 2);
            }
            text.SetText(t);
            text.Render(indexX, -this.height / 2.0f - Options.scl / 2.0f);
            i += interval;
        }
        interval = 0.1f;
        if (largestRow > 1.0f) {
            interval = 0.5f;
        }
        if (largestRow > 2.0f) {
            interval = 1.0f;
        }
        if (largestRow > 10.0f) {
            interval = 2.0f;
        }
        if (largestRow > 50.0f) {
            interval = 10.0f;
        }
        if (largestRow > 100.0f) {
            interval = 20.0f;
        }
        if (largestRow > 200.0f) {
            interval = 50.0f;
        }
        if (largestRow > 500.0f) {
            interval = 100.0f;
        }
        if (largestRow > 1000.0f) {
            interval = 500.0f;
        }
        if (largestRow > 10000.0f) {
            interval = 1000.0f;
        }
        if (largestRow > 100000.0f) {
            interval = 10000.0f;
        }
        text.FontSize(Tools.clampVar(largestRow / interval, Options.scl / 4.0f, Options.scl));
        i = 0.0f;
        while ((double)i <= Math.ceil(largestRow)) {
            float indexY = -this.height / 2.0f + padding / 2.0f + i / largestRow * (this.height - padding);
            RenderObjects.setColor(150.0f);
            RenderObjects.drawRect(0.0f, indexY, this.width, 10.0f * (this.height / this.width), 0.0f);
            t = String.valueOf((float)Math.round(i * 1000.0f) / 1000.0f);
            if (t.endsWith(".0")) {
                t = t.substring(0, t.length() - 2);
            }
            text.SetText(t);
            text.Calculate();
            text.Render(-this.width / 2.0f - Options.scl / 2.0f - text.Width() / 2.0f, indexY);
            i += interval;
        }
    }

    private boolean colorIsSame(int[] c1, int[] c2) {
        boolean result = true;
        int i = 0;
        while (i < 3) {
            if (c1[i] != c2[i]) {
                result = false;
            }
            ++i;
        }
        return result;
    }
}

