/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.menus;

import com.arizotaz.core.Boot;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.menus.Menu;
import com.arizotaz.core.tools.Download;
import com.arizotaz.core.tools.Management;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.WindowManager;
import java.util.HashMap;
import java.util.Map;

public class Debug
extends Menu {
    public static HashMap<String, Object> Fields = new HashMap();
    static long usedMemory = 0L;
    static long freeMemory = 0L;
    static long totalMemory = 0L;

    public static void MemTest() {
        if (Core.Platform().equals("windows")) {
            ThreadManager.Start(ThreadManager.Create("MemTest", new Thread(new Runnable(){

                @Override
                public void run() {
                    while (Core.debugMenu && Boot.run) {
                        long start = System.currentTimeMillis();
                        if (totalMemory == 0L) {
                            totalMemory = Management.GetSystemMemory();
                        }
                        usedMemory = Management.GetMemory();
                        freeMemory = Management.GetFreeSystemMemory();
                        long end = System.currentTimeMillis();
                        long time = end - start;
                        long wait = 1000L - time;
                        if (wait < 0L) {
                            wait = 0L;
                        }
                        try {
                            Thread.sleep(wait);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                }
            })));
        }
    }

    @Override
    public void Wake() {
        Debug.MemTest();
    }

    @Override
    public void Render() {
        int _r = Text.r;
        int _g = Text.g;
        int _b = Text.b;
        int _a = Text.a;
        Text.setColor(255);
        int fontSize = 11;
        int spacing = fontSize + 5;
        float _x = -Options.translateX;
        float _y = Options.translateY;
        int indexY = 0;
        Text.doBackground = true;
        Text.render(String.valueOf(Options.title) + " (" + Options.applicationID + ")", _x, _y - (float)(indexY * spacing), fontSize * 2, 200, Text.left);
        Text.render(Options.applicationVersion, _x, _y - (float)((indexY += 2) * spacing), fontSize * 2, 200, Text.left);
        Text.render("Lumonality Core " + Core.Version(), _x, _y - (float)((indexY += 2) * spacing), fontSize, 200, Text.left);
        ++indexY;
        Text.render("Window Info", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("FPS: " + Options.fpsAverage + "(" + Options.fpsHigh + "/" + Options.fpsLow + ")", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        boolean vsync = WindowManager.window.Vsync();
        Text.render("VSync: " + String.valueOf(vsync), _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Render Loop Time: " + RenderObjects.renderTime / 1000000L + "MS", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Window Size: " + Options.winWidth + " X " + Options.winHeight, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Canvas Size: " + Options.canvasWidth + " X " + Options.canvasHeight, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Window Swap Time: " + WindowManager.window.WindowTime() + "ms", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        Text.render("Java Info", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Heap: (" + Math.round(Management.GetHeap() / 0x100000L) + "m/" + Math.round(Management.GetMaxHeap() / 0x100000L) + "m) " + Math.round((float)Management.GetHeap() / (float)Management.GetMaxHeap() * 1000.0f) / 10 + "%", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        Text.render("System Info", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        if (Core.Platform().equals("windows")) {
            String memData = "Used: " + (float)Math.round((float)usedMemory / 1.0737418E9f * 10.0f) / 10.0f + "GB";
            Text.render("Memory " + memData, _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
            memData = "Free: " + (float)Math.round((float)freeMemory / 1.0737418E9f * 10.0f) / 10.0f + "GB";
            Text.render("Memory " + memData, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
            memData = "Total: " + (float)Math.round((float)totalMemory / 1.0737418E9f * 10.0f) / 10.0f + "GB";
            Text.render("Memory " + memData, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
            ++indexY;
        }
        Text.render("Total Process Time: " + WindowManager.window.ProcessTime() + "ms", _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        int threads = ThreadManager.AliveThreads();
        if (threads > 0) {
            Text.render("Total Active Threads: " + threads, _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
            ++indexY;
        }
        Text.render("Render Info", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Objects", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Objects Rendered: " + RenderObjects.debug_objects, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Texture Binds: " + RenderObjects.debug_binds, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Render Time: " + WindowManager.window.RenderTime() + "ms", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Render Maps: " + String.valueOf(RenderObjects.useMaps), _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        if (RenderObjects.useMaps) {
            Text.render("Render Maps Calc Time: " + RenderObjects.mapsProcessTime + "ms", _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
            ++indexY;
        }
        Text.render("Auto Focus: " + String.valueOf(Options.autoFocus), _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        ++indexY;
        for (Map.Entry<String, Object> me : Fields.entrySet()) {
            Text.render(String.valueOf(me.getKey()) + ": " + String.valueOf(me.getValue()), _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
            ++indexY;
        }
        Text.render("Network", _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Data Downloaded: " + Math.round(Download.totalBytes / 1000000.0f) + "/" + Math.round(Download.requiredBytes / 1000000.0f) + "MB %" + Math.round(Download.progress * 100.0f), _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        Text.render("Files Downloaded: " + Download.filesDownloaded + "/" + Download.filesToDownload, _x, _y - (float)(++indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        ++indexY;
        String keysDown = "";
        int i = 0;
        while (i < 1000) {
            if (KeyboardInput.isKeyDown(i)) {
                keysDown = String.valueOf(keysDown) + i + ",";
            }
            ++i;
        }
        Text.render("Keys Down: " + keysDown, _x, _y - (float)(indexY * spacing), fontSize, 200, Text.left);
        ++indexY;
        ++indexY;
        Text.doBackground = false;
        if (Fields.size() > 0) {
            Fields = new HashMap();
        }
        Text.setColor(_r, _g, _b, _a);
    }

    @Override
    public void Leave() {
    }
}

