/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.menus;

import com.arizotaz.core.Core;
import com.arizotaz.core.Engine;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.menus.Menu;
import com.arizotaz.core.tools.Download;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.ui.Button;
import com.arizotaz.core.window.Mouse;

public class ParseXLInstaller
extends Menu {
    public static Download download = null;
    int downloadThread = -1;

    @Override
    public void Wake() {
        this.downloadThread = -1;
        Mouse.mouseLeftIsDown = 0;
        Mouse.mouseRightIsDown = 0;
        Mouse.clicked = false;
    }

    @Override
    public void Render() {
        boolean isDownloading = false;
        if (this.downloadThread != -1 && ThreadManager.IsAlive(this.downloadThread)) {
            isDownloading = true;
        }
        RenderObjects.setColor(255.0f);
        RenderObjects.drawRect(0.0f, 0.0f, Options.canvasWidth, Options.canvasHeight, 0.0f);
        RenderObjects.setColor(0.0f, 0.0f, 0.0f, 100.0f);
        RenderObjects.drawRect(0.0f, 0.0f, Options.canvasWidth, Options.canvasHeight, 0.0f);
        float scl = Options.DefaultScale();
        float boxWidth = Tools.clampVar(scl * 18.0f, 0.0f, Options.canvasWidth);
        float boxHeight = Tools.clampVar(scl * 25.0f, 0.0f, Options.canvasHeight);
        if (isDownloading) {
            boxWidth = Tools.clampVar(scl * 25.0f, 0.0f, Options.canvasWidth);
            boxHeight = Tools.clampVar(scl * 10.0f, 0.0f, Options.canvasHeight);
        }
        RenderObjects.setColor(0.0f, 0.0f, 0.0f);
        RenderObjects.drawRoundedRect(0.0, 0.0, 0.0, boxWidth, boxHeight, scl, 3);
        Options.translate(0.0f, boxHeight / 2.0f - scl);
        float yIndex = 0.0f;
        Text text = new Text("ParseXL");
        text.SetSpaceWidth(0.6f);
        text.SetLineSpacing(1.2f);
        text.MaxWidth(boxWidth - scl);
        text.FontSize(scl * 2.0f);
        text.Color(255);
        text.Align(1, 0);
        text.Render(0.0f, yIndex);
        yIndex -= text.Height();
        if (isDownloading) {
            text.SetText("is downloading");
            text.FontSize(scl);
            text.Render(0.0f, yIndex);
            yIndex -= text.Height() + scl;
            RenderObjects.setColor(100.0f);
            RenderObjects.drawRect(0.0f, yIndex -= scl * 3.0f, boxWidth - scl * 2.0f, scl, 0.0f);
            float percentageComplete = Download.progress;
            RenderObjects.setColor(255.0f);
            RenderObjects.drawRect(-(boxWidth - scl * 2.0f) / 2.0f + (boxWidth - scl * 2.0f) * percentageComplete / 2.0f, yIndex, (boxWidth - scl * 2.0f) * percentageComplete, scl, 0.0f);
            return;
        }
        text.SetText("is not installed");
        text.FontSize(scl);
        text.Render(0.0f, yIndex);
        text.SetText("\t\tParseXL is responsible for reading and writing Excel Documents.  If this is not installed the application is not able to perform these actions.  Luckily, you may install ParseXL from within this application.");
        text.FontSize(scl);
        text.Render(0.0f, yIndex -= text.Height() + scl);
        Button button = new Button();
        button.Set("Download ParseXL", 0.0f, yIndex -= text.Height() + scl * 2.0f, boxWidth - scl * 2.0f, scl * 1.5f);
        button.Render();
        if (button.IsClicked()) {
            this.downloadThread = ThreadManager.Create("ParseXL Install", new Thread(new Runnable(){

                @Override
                public void run() {
                    download = new Download("https://lumonality.com/libraries/PARSEXL.jar", String.valueOf(Options.container) + "assets/PARSEXL.jar");
                    Core.ui = 0;
                }
            }));
            ThreadManager.Start(this.downloadThread);
        }
        button = new Button();
        button.Set("Download Later", 0.0f, yIndex -= scl * 2.0f, boxWidth - scl * 2.0f, scl * 1.5f);
        button.Render();
        if (button.IsClicked()) {
            Core.ui = 0;
        }
        yIndex -= scl * 2.0f;
        Engine.blockButtons = true;
        Engine.blockInput = true;
        Engine.blockInputField = true;
        Engine.blockMouse = true;
    }

    @Override
    public void Leave() {
    }
}

