/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.nautilus;

import com.arizotaz.core.Options;
import com.arizotaz.core.nautilus.Nautilus;
import com.arizotaz.core.reqs.MultipartUtility;
import com.arizotaz.core.tools.Download;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;

public class Cloud {
    public static String Upload(String location) throws MalformedURLException, IOException {
        if (!Nautilus.LoggedIn()) {
            return "[CLOUD] User is not logged in";
        }
        System.out.println("[CLOUD] Uploading a file");
        File file = new File(location);
        String charset = "UTF-8";
        String requestURL = "https://lumonality.com/api/cloud/upload/";
        MultipartUtility multipart = new MultipartUtility(requestURL, charset);
        multipart.addHeaderField("User-Agent", "ArizotazCore_" + Options.applicationID);
        multipart.addHeaderField("Test-Header", "Header-Value");
        multipart.addFormField("applicationReference", Nautilus.ApplicationReference());
        multipart.addFormField("sessionID", Nautilus.SessionID());
        multipart.addFormField("sessionKey", Nautilus.SessionKey());
        multipart.addFilePart("data", file);
        String result = "";
        List<String> response = multipart.finish();
        for (String line : response) {
            result = String.valueOf(result) + line;
        }
        System.out.println("[CLOUD] Upload Result: " + result);
        return result;
    }

    public static void Download(String fileName, String location) throws MalformedURLException, IOException {
        int numBytesRead;
        if (!Nautilus.LoggedIn()) {
            return;
        }
        System.out.println("[CLOUD] Downloading " + fileName);
        URL url = new URL("https://lumonality.com/api/cloud/read/");
        URLConnection con = url.openConnection();
        HttpURLConnection http = (HttpURLConnection)con;
        http.setRequestMethod("POST");
        http.setDoOutput(true);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("applicationReference", Nautilus.ApplicationReference());
        arguments.put("sessionID", Nautilus.SessionID());
        arguments.put("sessionKey", Nautilus.SessionKey());
        arguments.put("filename", fileName);
        StringJoiner sj = new StringJoiner("&");
        for (Map.Entry entry : arguments.entrySet()) {
            sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
        }
        byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
        int length = out.length;
        http.setFixedLengthStreamingMode(length);
        http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        http.connect();
        Throwable throwable = null;
        Object var10_12 = null;
        try (OutputStream os = http.getOutputStream();){
            os.write(out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
        String tempLocation = String.valueOf(Options.downloads) + "CLOUD" + fileID;
        while (new File(tempLocation).exists()) {
            fileID = String.valueOf((int)Math.round(Math.random() * 1000000.0));
            tempLocation = String.valueOf(Options.downloads) + "CLOUD" + fileID;
        }
        new File(tempLocation).createNewFile();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(http.getInputStream());
        FileOutputStream fileOutputStream = new FileOutputStream(tempLocation);
        float fileSize = http.getContentLength();
        Download.requiredBytes += fileSize;
        Download._requiredBytes += fileSize;
        byte[] bucket = new byte[2048];
        while ((numBytesRead = bufferedInputStream.read(bucket, 0, bucket.length)) != -1) {
            fileOutputStream.write(bucket, 0, numBytesRead);
            Download.totalBytes += (float)numBytesRead;
            Download._totalBytes += (float)numBytesRead;
        }
        fileOutputStream.close();
        bufferedInputStream.close();
        System.out.println("[CLOUD] Trying to move " + tempLocation + " to " + location);
        try {
            Path fileToMovePath = Paths.get(tempLocation, new String[0]);
            Path targetPath = Paths.get(location, new String[0]);
            Files.move(fileToMovePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            System.out.println("[CLOUD] Moved " + tempLocation + " to " + location);
        }
        catch (IOException e1) {
            System.out.print("[CLOUD] ERROR");
            e1.printStackTrace();
        }
    }
}

