/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.nautilus;

import com.arizotaz.core.Boot;
import com.arizotaz.core.Options;
import com.arizotaz.core.Texture;
import com.arizotaz.core.tools.Fs;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.tools.Web;
import com.arizotaz.core.window.WindowManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Nautilus {
    public static String applicationID = "";
    public static String applicationKey = "";
    private static String applicationReference = "";
    private static String loginID = "";
    private static int referenceThread;
    private static int checkThread;
    private static boolean autoOpenLogin;
    public static String loginMessage;
    private static boolean loggedIn;
    private static String sessionID;
    private static String sessionKey;
    private static String publicSessionKey;
    private static JSONObject sessionData;
    public static JSONObject accountData;
    public static boolean runLoginLoop;
    private static String profileID;
    private static String bannerID;
    public static boolean logActivity;
    private static int activityLoop;

    static {
        autoOpenLogin = true;
        loginMessage = "";
        loggedIn = false;
        sessionID = "";
        sessionKey = "";
        publicSessionKey = "";
        sessionData = null;
        accountData = null;
        runLoginLoop = false;
        profileID = "";
        bannerID = "";
        logActivity = true;
        activityLoop = -1;
    }

    public static void ResetVals() {
        applicationReference = "";
        loginID = "";
        loginMessage = "";
        loggedIn = false;
        sessionID = "";
        sessionKey = "";
        sessionData = null;
        accountData = null;
    }

    public static void SaveSession() throws FileNotFoundException, IOException {
        String[] vals = new String[]{applicationID, applicationReference, loginID, sessionID, sessionKey};
        Fs.Write(new File(String.valueOf(Options.appData) + "ses"), vals);
    }

    public static void LoadSession() {
        if (new File(String.valueOf(Options.appData) + "ses").exists()) {
            String[] vals = (String[])Fs.Read(new File(String.valueOf(Options.appData) + "ses"));
            applicationID = vals[0];
            applicationReference = vals[1];
            loginID = vals[2];
            sessionID = vals[3];
            sessionKey = vals[4];
            if (Nautilus.SessionActive()) {
                loggedIn = true;
                Nautilus.GetAccountInfo();
            }
        }
    }

    public static void Authenticate() {
        loggedIn = false;
        Nautilus.CreateReference();
    }

    public static void Check() {
        runLoginLoop = true;
        while (runLoginLoop && Boot.run) {
            try {
                if (!loginID.equals("")) {
                    Nautilus.CheckLogin();
                }
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void CreateReference() {
        try {
            String inputLine;
            loginMessage = "Creating Reference";
            URL url = new URL("https://lumonality.com/nautilus/trident/application/reference/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("id", applicationID);
            arguments.put("key", applicationKey);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            if (result.startsWith("{")) {
                JSONParser parser = new JSONParser();
                JSONObject json = null;
                json = (JSONObject)parser.parse(result);
                applicationReference = json.get((Object)"id").toString();
                Nautilus.CreateSession();
            } else {
                loginMessage = "Error Creating Reference " + result;
            }
        }
        catch (Exception e) {
            loginMessage = "Error Creating Reference " + e.toString();
        }
    }

    static void CreateSession() {
        try {
            String inputLine;
            loginMessage = "Creating Session";
            URL url = new URL("https://lumonality.com/nautilus/trident/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("action", "start");
            arguments.put("applicationReference", applicationReference);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            if (result.startsWith("{")) {
                JSONParser parser = new JSONParser();
                JSONObject json = null;
                json = (JSONObject)parser.parse(result);
                loginID = json.get((Object)"loginID").toString();
                if (autoOpenLogin) {
                    Nautilus.OpenLoginWindow();
                }
            } else {
                loginMessage = "Error Creating Session " + result;
            }
        }
        catch (Exception e) {
            loginMessage = "Error Creating Session " + e.toString();
        }
    }

    public static void AutoOpenLogin(boolean val) {
        autoOpenLogin = val;
    }

    public static void OpenLoginWindow() {
        String loginURL = "https://lumonality.com/nautilus/trident/login/?l=" + loginID;
        if (System.getProperty("key") != null) {
            loginURL = String.valueOf(loginURL) + "&k=" + System.getProperty("key");
            if (Web.WebPlayerInstalled()) {
                Web.OpenWebPlayer(loginURL, 430, 650);
            } else {
                Web.open(loginURL, true);
            }
        } else {
            Web.open(loginURL, true);
        }
    }

    static void CheckLogin() {
        try {
            String inputLine;
            URL url = new URL("https://lumonality.com/nautilus/trident/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("action", "check");
            arguments.put("applicationReference", applicationReference);
            arguments.put("loginID", loginID);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            if (result.startsWith("{")) {
                JSONParser parser = new JSONParser();
                sessionData = (JSONObject)parser.parse(result);
                sessionID = sessionData.get((Object)"sessionID").toString();
                sessionKey = sessionData.get((Object)"sessionKey").toString();
                publicSessionKey = sessionData.get((Object)"publicKey").toString();
                Nautilus.GetAccountInfo();
            } else {
                loginMessage = result;
                if (!result.startsWith("*")) {
                    Nautilus.StopLogin();
                }
            }
        }
        catch (Exception e) {
            loginMessage = "Error Checking Session " + e.toString();
        }
    }

    public static boolean SessionActive() {
        boolean active = false;
        try {
            String inputLine;
            URL url = new URL("https://lumonality.com/nautilus/trident/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("action", "validate");
            arguments.put("applicationReference", applicationReference);
            arguments.put("sessionID", sessionID);
            arguments.put("sessionKey", sessionKey);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var9_12 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            if (result.startsWith("{")) {
                JSONParser parser = new JSONParser();
                JSONObject dat = (JSONObject)parser.parse(result);
                if (dat.get((Object)"status").toString().equals("active")) {
                    active = true;
                    loggedIn = true;
                }
            } else {
                loginMessage = result;
            }
        }
        catch (Exception e) {
            loginMessage = "Error Checking Session " + e.toString();
        }
        return active;
    }

    static void GetAccountInfo() {
        try {
            String inputLine;
            URL url = new URL("https://lumonality.com/nautilus/trident/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("action", "info");
            arguments.put("applicationReference", applicationReference);
            arguments.put("sessionID", sessionID);
            arguments.put("sessionKey", sessionKey);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            if (result.startsWith("{")) {
                JSONParser parser = new JSONParser();
                accountData = (JSONObject)parser.parse(result);
                loggedIn = true;
                loginMessage = "Done";
                runLoginLoop = false;
                WindowManager.window.focus();
                System.out.println("------[ Logged: " + accountData.get((Object)"username").toString() + "(" + accountData.get((Object)"accountID").toString() + ") ]------");
                Nautilus.CreateActivityLoop();
            } else {
                loginMessage = result;
            }
        }
        catch (Exception e) {
            loginMessage = "Error Checking Session " + e.toString();
        }
    }

    public static void CreateActivityLoop() {
        if (logActivity) {
            ThreadManager.Start(ThreadManager.Create("App Activity Start", new Thread(new Runnable(){

                @Override
                public void run() {
                    Nautilus.LogActivity();
                }
            })));
        }
        activityLoop = ThreadManager.Create("App Activity Loop", new Thread(new Runnable(){

            @Override
            public void run() {
                int passes = 0;
                while (Boot.run && logActivity) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (++passes <= 120) continue;
                    Nautilus.LogActivity();
                    passes = 0;
                }
            }
        }));
        ThreadManager.Start(activityLoop);
    }

    public static void LogActivity() {
        try {
            String inputLine;
            URL url = new URL("https://lumonality.com/api/nautilus/session/playtime/");
            URLConnection con = url.openConnection();
            HttpURLConnection http = (HttpURLConnection)con;
            http.setRequestMethod("POST");
            http.setDoOutput(true);
            HashMap<String, String> arguments = new HashMap<String, String>();
            arguments.put("sessionID", sessionID);
            arguments.put("publicKey", publicSessionKey);
            StringJoiner sj = new StringJoiner("&");
            for (Map.Entry entry : arguments.entrySet()) {
                sj.add(String.valueOf(URLEncoder.encode((String)entry.getKey(), "UTF-8")) + "=" + URLEncoder.encode((String)entry.getValue(), "UTF-8"));
            }
            byte[] out = sj.toString().getBytes(StandardCharsets.UTF_8);
            int length = out.length;
            http.setFixedLengthStreamingMode(length);
            http.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            http.connect();
            Throwable throwable = null;
            Object var8_11 = null;
            try (OutputStream os = http.getOutputStream();){
                os.write(out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(http.getInputStream()));
            String result = "";
            while ((inputLine = in.readLine()) != null) {
                result = String.valueOf(result) + inputLine;
            }
            System.out.println("[Activity Loop]" + result);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String SessionID() {
        return sessionID;
    }

    public static String SessionKey() {
        return sessionKey;
    }

    public static String PublicKey() {
        return publicSessionKey;
    }

    public static String ApplicationReference() {
        return applicationReference;
    }

    public static String LoginID() {
        return loginID;
    }

    public static void GetProfileImages() {
        profileID = accountData.get((Object)"accountID") + "_profile";
        bannerID = accountData.get((Object)"accountID") + "_banner";
        Texture.urlToMap(profileID, "https://lumonality.com/account/profile/?account=" + accountData.get((Object)"accountID"), true);
        Texture.urlToMap(bannerID, "https://lumonality.com/account/banner/?account=" + accountData.get((Object)"accountID"), true);
    }

    public static String ProfileID() {
        return profileID;
    }

    public static String BannerID() {
        return bannerID;
    }

    public static boolean LoggedIn() {
        return loggedIn;
    }

    public static void StopLogin() {
        if (runLoginLoop) {
            loggedIn = false;
        }
        runLoginLoop = false;
    }
}

