/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.parseXL;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.tools.Fs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class PARSEXL {
    public static String parseXLjar = "";
    public static String status = "";
    public static JSONObject importJSON;
    private static boolean showWindow;

    static {
        showWindow = false;
    }

    public static boolean installed() {
        status = "Checking Installation";
        try {
            String jsonLibrary = Fs.ReadText(new File(String.valueOf(Options.container) + "portal/library.json"));
            JSONParser parser = new JSONParser();
            JSONObject libraryDat = (JSONObject)parser.parse(jsonLibrary);
            JSONObject apps = (JSONObject)libraryDat.get((Object)"apps");
            JSONObject PARSEXL2 = (JSONObject)apps.get((Object)"PARSEXL");
            String appLocation = PARSEXL2.get((Object)"appFolder").toString();
            if (appLocation == null || appLocation.equals("")) {
                throw new Exception("PARSEXL not installed via Portal");
            }
            if (!appLocation.endsWith("/") && !appLocation.endsWith("\\")) {
                appLocation = String.valueOf(appLocation) + "/";
            }
            if (!new File(String.valueOf(appLocation) + "PARSEXL.jar").exists()) {
                throw new Exception("Could not find PARSEXL.jar");
            }
            parseXLjar = new File(String.valueOf(appLocation) + "PARSEXL.jar").getAbsolutePath();
            Analytics.Warn("Found installed PARSEXL in Lumonality Launcher");
            return true;
        }
        catch (Exception e) {
            if (new File(String.valueOf(Options.container) + "portal/app/PARSEXL/PARSEXL.jar").exists()) {
                parseXLjar = new File(String.valueOf(Options.container) + "portal/app/PARSEXL/PARSEXL.jar").getAbsolutePath();
                return true;
            }
            if (new File(String.valueOf(Options.container) + "assets/PARSEXL.jar").exists()) {
                parseXLjar = new File(String.valueOf(Options.container) + "assets/PARSEXL.jar").getAbsolutePath();
                return true;
            }
            Core.ui = 10;
            return false;
        }
    }

    public static void ShowWindow() {
        showWindow = true;
    }

    public static void HideWindow() {
        showWindow = false;
    }

    public static void ToggleWindow() {
        showWindow = !showWindow;
    }

    public static boolean WindowVisible() {
        return showWindow;
    }

    public static void ImportFile(File excelFile) throws IOException, ParseException {
        if (PARSEXL.installed()) {
            status = "Creating temp file";
            int i = 0;
            String loc = Options.appData;
            while (new File(String.valueOf(loc) + i + "_load.json").exists()) {
                ++i;
            }
            File saveToFile = new File(String.valueOf(loc) + i + "_load.json");
            saveToFile.createNewFile();
            status = "Launching ParseXL";
            String extra = "-Dextra";
            if (!Core.Platform().equals("windows")) {
                extra = "-XstartOnFirstThread";
            }
            String windowSetting = "-Dwin";
            if (!showWindow) {
                windowSetting = "-DnoWindow=true";
            }
            ProcessBuilder pb = new ProcessBuilder(Options.javaCommand, extra, "-DreadFile=" + excelFile.getAbsolutePath(), "-DsaveLoc=" + saveToFile.getAbsolutePath(), windowSetting, "-jar", parseXLjar);
            Process p = pb.start();
            status = "Listening to ParseXL";
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String result = builder.toString();
            reader.close();
            if (result.contains("SAVED:")) {
                String st;
                status = "Reading returned data";
                String fileContent = "";
                BufferedReader br = new BufferedReader(new FileReader(saveToFile));
                while ((st = br.readLine()) != null) {
                    fileContent = String.valueOf(fileContent) + st;
                }
                br.close();
                status = "Parsing JSON";
                JSONParser parse = new JSONParser();
                importJSON = (JSONObject)parse.parse(fileContent);
                System.out.println("Imported " + excelFile.getAbsolutePath());
            } else {
                status = "Fail";
                System.out.println("Failed to read Excel File");
                Core.banner("Failed to read Excel File");
            }
            status = "Cleaning up";
            Fs.ForceRemove(saveToFile);
        } else {
            System.out.println("parseXL is not installed");
            Core.banner("parseXL is not installed");
        }
    }

    public static void SaveFile(String json) throws IOException {
        if (PARSEXL.installed()) {
            status = "Creating temp file";
            int i = 0;
            String loc = Options.appData;
            while (new File(String.valueOf(loc) + i + "_write.json").exists()) {
                ++i;
            }
            File saveLocation = new File(String.valueOf(loc) + i + "_write.json");
            FileWriter saveFile = new FileWriter(saveLocation);
            saveFile.write(json);
            saveFile.close();
            status = "Launching ParseXL";
            String extra = "-Dextra";
            if (!Core.Platform().equals("windows")) {
                extra = "-XstartOnFirstThread";
            }
            String windowSetting = "-Dwin";
            if (!showWindow) {
                windowSetting = "-DnoWindow=true";
            }
            ProcessBuilder pb = new ProcessBuilder(Options.javaCommand, extra, "-DloadFile=" + saveLocation.getAbsolutePath(), windowSetting, "-jar", parseXLjar);
            Process p = pb.start();
            status = "Listening to ParseXL";
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            StringBuilder builder = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
            String result = builder.toString();
            reader.close();
            if (result.contains("EXCELEXPORTDONE")) {
                System.out.println("SUCCESS");
                status = "SUCCESS";
            } else {
                status = "Fail";
                System.err.println(result);
                System.out.println("Failed to Write Excel File");
                Core.banner("Failed to Write Excel File");
            }
            status = "Cleaning up";
            Fs.ForceRemove(saveLocation);
        } else {
            System.out.println("parseXL is not installed");
            Core.banner("parseXL is not installed");
        }
    }
}

