/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.reqs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import org.lwjgl.BufferUtils;

public class BufferUtilities {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String loadResource(String fileName) throws Exception {
        Throwable throwable = null;
        Object var3_3 = null;
        try {
            String result;
            InputStream in = BufferUtilities.class.getResourceAsStream(fileName);
            try {
                try (Scanner scanner = new Scanner(in, StandardCharsets.UTF_8.name());){
                    result = scanner.useDelimiter("\\A").next();
                }
                if (in == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static List<String> readAllLines(String fileName) throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Class.forName(BufferUtilities.class.getName()).getResourceAsStream(fileName)));){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return list;
    }

    public static int[] listIntToArray(List<Integer> list) {
        int[] result = list.stream().mapToInt(v -> v).toArray();
        return result;
    }

    public static float[] listToArray(List<Float> list) {
        int size = list != null ? list.size() : 0;
        float[] floatArr = new float[size];
        int i = 0;
        while (i < size) {
            floatArr[i] = list.get(i).floatValue();
            ++i;
        }
        return floatArr;
    }

    public static boolean existsResourceFile(String fileName) {
        boolean result;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStream is = BufferUtilities.class.getResourceAsStream(fileName);){
                result = is != null;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception excp) {
            result = false;
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        block22: {
            Path path = Paths.get(resource, new String[0]);
            if (Files.isReadable(path)) {
                Throwable throwable = null;
                Object var5_7 = null;
                try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                    buffer = BufferUtils.createByteBuffer((int)((int)fc.size() + 1));
                    while (fc.read(buffer) != -1) {
                    }
                    break block22;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var5_9 = null;
            try {
                InputStream source = BufferUtilities.class.getResourceAsStream(resource);
                try {
                    try (ReadableByteChannel rbc = Channels.newChannel(source);){
                        int bytes;
                        buffer = BufferUtils.createByteBuffer((int)bufferSize);
                        while ((bytes = rbc.read(buffer)) != -1) {
                            if (buffer.remaining() != 0) continue;
                            buffer = BufferUtilities.resizeBuffer(buffer, buffer.capacity() * 2);
                        }
                    }
                    if (source == null) break block22;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (source == null) throw throwable;
                    source.close();
                    throw throwable;
                }
                source.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = BufferUtils.createByteBuffer((int)newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }
}

