/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.struc;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.Texture;
import com.arizotaz.core.tools.Download;
import com.arizotaz.core.tools.Fs;
import java.io.File;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Font {
    String name = "";
    String texture = "";
    boolean bold = false;
    boolean filter = true;
    float width = 0.0f;
    float height = 0.0f;
    float largestChar = 0.0f;
    HashMap<Character, Char> characters = new HashMap();

    public Font(String name) {
        this.name = name;
        if (this.name.equals("")) {
            this.name = "FONT" + Math.round(Math.random() * 1000000.0);
        }
        Analytics.Log("Created font container named: " + name);
    }

    public void importURL(String URL2) {
        Analytics.Log("Importing Font Via URL " + URL2);
        if (!new File("Options.cache+\"font_\"+name").exists()) {
            new Download(URL2, String.valueOf(Options.cache) + "font_" + this.name);
        }
        this.importData(Fs.ReadText(new File(String.valueOf(Options.cache) + "font_" + this.name)));
    }

    public void importLocal(String ioLocation) {
        Analytics.Log("Importing Font Via Package " + ioLocation);
        try {
            String dat = Fs.getResourceFileAsString(ioLocation);
            this.importData(dat);
        }
        catch (Exception e) {
            e.printStackTrace();
            Analytics.Error(e.toString());
        }
    }

    public void importFile(String fileLocation) {
        Analytics.Log("Importing Font Via Local File " + fileLocation);
        if (!new File(fileLocation).exists()) {
            this.importData(Fs.ReadText(new File(fileLocation)));
        }
    }

    void importData(String result) {
        this.largestChar = 0.0f;
        this.width = 0.0f;
        this.height = 0.0f;
        try {
            JSONParser parser = new JSONParser();
            JSONObject json = null;
            json = (JSONObject)parser.parse(result);
            this.name = (String)json.get((Object)"name");
            if (json.get((Object)"antialias") != null) {
                this.filter = Boolean.parseBoolean(String.valueOf(json.get((Object)"antialias")));
            }
            if (json.get((Object)"texture").toString().startsWith("http")) {
                Texture.urlToMap("font_" + this.name + "_texture", (String)json.get((Object)"texture"), this.filter);
                this.texture = "font_" + this.name + "_texture";
            } else {
                boolean outside = json.get((Object)"texture").toString().startsWith("/") || json.get((Object)"texture").toString().substring(0, 2).contains(":");
                Texture.AddToLoadList("font_" + this.name + "_texture", json.get((Object)"texture").toString(), outside, this.filter);
                this.texture = "font_" + this.name + "_texture";
            }
            this.width = Float.parseFloat(String.valueOf(json.get((Object)"width")));
            this.height = Float.parseFloat(String.valueOf(json.get((Object)"height")));
            JSONObject characters = (JSONObject)json.get((Object)"characters");
            for (String key : characters.keySet()) {
                JSONObject charDat = (JSONObject)characters.get((Object)key);
                Char charObject = new Char(key.toCharArray()[0], Integer.parseInt(String.valueOf(charDat.get((Object)"x"))), Integer.parseInt(String.valueOf(charDat.get((Object)"y"))), Integer.parseInt(String.valueOf(charDat.get((Object)"width"))), Integer.parseInt(String.valueOf(charDat.get((Object)"height"))), Integer.parseInt(String.valueOf(charDat.get((Object)"originX"))), Integer.parseInt(String.valueOf(charDat.get((Object)"originY"))), Integer.parseInt(String.valueOf(charDat.get((Object)"advance"))));
                if ((float)Integer.parseInt(String.valueOf(charDat.get((Object)"height"))) > this.largestChar) {
                    this.largestChar = Integer.parseInt(String.valueOf(charDat.get((Object)"height")));
                }
                this.characters.put(Character.valueOf(key.toCharArray()[0]), charObject);
            }
        }
        catch (Exception e) {
            Core.banner("Failed to import font: " + e.toString());
            Analytics.Error("Failed to import font");
            e.printStackTrace();
        }
    }

    public String Texture() {
        return this.texture;
    }

    public Char getChar(char c) {
        return this.characters.get(Character.valueOf(c));
    }

    public float Width() {
        return this.width;
    }

    public float Height() {
        return this.height;
    }

    public float LargestCharHeight() {
        return this.largestChar;
    }

    public class Char {
        char character;
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        int originX = 0;
        int originY = 0;
        int advance = 0;

        public Char(char character, int x, int y, int w, int h, int ox, int oy, int ad) {
            this.character = character;
            this.x = x;
            this.y = y;
            this.width = w;
            this.height = h;
            this.originX = ox;
            this.originY = oy;
            this.advance = ad;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public int originX() {
            return this.originX;
        }

        public int originY() {
            return this.originY;
        }

        public int advance() {
            return this.advance;
        }
    }
}

