/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.tools;

import com.arizotaz.core.Boot;
import com.arizotaz.core.Options;
import com.arizotaz.core.tools.Tools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Fs {
    public static boolean deleteFolder(File directoryToBeDeleted) {
        File[] allContents;
        boolean fullyDelete = true;
        if (directoryToBeDeleted.isDirectory() && (allContents = directoryToBeDeleted.listFiles()) != null) {
            File[] fileArray = allContents;
            int n = allContents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                boolean deleted = Fs.deleteFolder(file);
                if (fullyDelete && !deleted) {
                    fullyDelete = false;
                }
                ++n2;
            }
        }
        Fs.ForceRemove(directoryToBeDeleted);
        return fullyDelete;
    }

    public static long FolderSize(File directory) {
        return Fs.GetFolderSize(directory);
    }

    public static long GetFolderSize(File directory) {
        long length = 0L;
        try {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile()) {
                    length += file.length();
                } else if (length <= 100000000000L) {
                    length += Fs.GetFolderSize(file);
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return length;
    }

    public static boolean ForceRemove(File file) {
        int attempts = 0;
        boolean exit = false;
        while (file.exists() && !exit) {
            file.delete();
            if (++attempts <= 2) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (attempts <= 10) continue;
            exit = true;
            System.out.println("Failed to delete file " + file.getAbsolutePath());
        }
        return !exit;
    }

    public static void Write(File location, Object value) throws FileNotFoundException, IOException {
        Fs.CreateDirs(location);
        File dir = new File(Options.appData);
        dir.mkdirs();
        ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(location));
        outputStream.writeObject(value);
        outputStream.close();
    }

    public static Object Read(File location) {
        Object object = null;
        if (location.exists()) {
            try {
                if (location.exists()) {
                    Object item;
                    ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(location));
                    object = item = inputStream.readObject();
                    inputStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    public static boolean WriteText(File location, String text) {
        Fs.CreateDirs(location);
        boolean result = false;
        try {
            FileWriter myWriter = new FileWriter(location);
            myWriter.write(text);
            myWriter.close();
            result = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String ReadText(File location) {
        String result = "";
        try {
            int i;
            FileReader fr = new FileReader(location);
            while ((i = fr.read()) != -1) {
                result = String.valueOf(result) + (char)i;
            }
            fr.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean CreateDirs(File location) {
        File parentDir = location.getParentFile();
        String name = location.getName();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public static String getResourceFileAsString(String fileName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String JarLocation() {
        String jarFolder = Options.appData;
        try {
            jarFolder = new File(Boot.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath().replace('\\', '/');
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return jarFolder;
    }

    public static boolean ExportResource(String fileName, String location) {
        fileName = "/" + fileName;
        try {
            Files.copy(Options.class.getResourceAsStream(fileName), new File(location).toPath(), StandardCopyOption.REPLACE_EXISTING);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static File FindOpenTempFile() {
        File file = new File(String.valueOf(Options.temp) + Tools.RandomSafeChars(24));
        while (file.exists()) {
            file = new File(String.valueOf(Options.temp) + Tools.RandomSafeChars(24));
        }
        return file;
    }

    public static String MD5Hash(File file) throws NoSuchAlgorithmException, IOException {
        MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        String checksum = Fs.GetFileChecksum(md5Digest, file);
        return checksum;
    }

    private static String GetFileChecksum(MessageDigest digest, File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] byteArray = new byte[1024];
        int bytesCount = 0;
        while ((bytesCount = fis.read(byteArray)) != -1) {
            digest.update(byteArray, 0, bytesCount);
        }
        fis.close();
        byte[] bytes = digest.digest();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            sb.append(Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }
}

