/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.tools;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;

public class TextShorts {
    public static String UCFWords(String dat) {
        String built = "";
        String[] broken = dat.split(" ");
        int i = 0;
        while (i < broken.length) {
            String word = broken[i];
            built = String.valueOf(built) + TextShorts.UCFWord(word) + " ";
            ++i;
        }
        return built.substring(0, built.length() - 1);
    }

    public static String UCFWord(String dat) {
        if (!dat.equals("")) {
            if (dat.length() > 1) {
                String letter = dat.substring(0, 1).toUpperCase();
                String rest = dat.substring(1).toLowerCase();
                return String.valueOf(letter) + rest;
            }
            return dat.toUpperCase();
        }
        return dat;
    }

    public static String SizeToText(long size) {
        String suffix = " Bytes";
        if (size > 1000L) {
            size = Math.round(size / 1000L);
            suffix = " KBs";
            if (size > 1000L) {
                size = Math.round(size / 1000L);
                suffix = " MBs";
                if (size > 1000L) {
                    size = Math.round(size / 1000L);
                    suffix = " GBs";
                }
            }
        }
        return String.valueOf(size) + suffix;
    }

    public static String SizeToTextFrac(double size) {
        String text;
        String suffix = " Bytes";
        if (size > 1000.0) {
            size = (double)Math.round(size / 100.0) / 10.0;
            suffix = " KBs";
            if (size > 1000.0) {
                size = (double)Math.round(size / 100.0) / 10.0;
                suffix = " MBs";
                if (size > 1000.0) {
                    size = (double)Math.round(size / 10.0) / 10.0;
                    suffix = " GBs";
                }
            }
        }
        if ((text = String.valueOf(size)).endsWith(".0")) {
            text = text.substring(0, text.length() - 2);
        }
        return String.valueOf(text) + suffix;
    }

    public static String MSToDate(long ms) {
        return TextShorts.MSToDate(ms, "MM-dd-yyyy");
    }

    public static String MSToDate(long ms, String pattern) {
        LocalDate dateObj = Instant.ofEpochMilli(ms).atZone(ZoneId.systemDefault()).toLocalDate();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        return dateObj.format(formatter);
    }
}

