/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.tools;

import com.arizotaz.core.Analytics;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.menus.Link;
import com.arizotaz.core.tools.Fs;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.tools.Tools;
import java.io.File;
import java.util.ArrayList;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class Web {
    private static String webPlayerexe = "";

    public static void open(String url) {
        Web.open(url, url.startsWith("https://arizotaz.com") || url.startsWith("https://lumonality.com"));
    }

    public static void open(String url, boolean trusted) {
        if (trusted) {
            Web._open(url);
        } else {
            Link.url = url;
            Core.ui = 2;
        }
    }

    public static void _open(final String url) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime rt;
                    String os = System.getProperty("os.name").toLowerCase();
                    if (os.indexOf("win") >= 0) {
                        rt = Runtime.getRuntime();
                        rt.exec("rundll32 url.dll,FileProtocolHandler " + url);
                    }
                    if (os.indexOf("mac") >= 0) {
                        rt = Runtime.getRuntime();
                        rt.exec("open " + url);
                    }
                    if (os.indexOf("nix") >= 0 || os.indexOf("nux") >= 0) {
                        rt = Runtime.getRuntime();
                        String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                        StringBuffer cmd = new StringBuffer();
                        int i = 0;
                        while (i < browsers.length) {
                            if (i == 0) {
                                cmd.append(String.format("%s \"%s\"", browsers[i], url));
                            } else {
                                cmd.append(String.format(" || %s \"%s\"", browsers[i], url));
                            }
                            ++i;
                        }
                        rt.exec(new String[]{"sh", "-c", cmd.toString()});
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (Core.ui == 2) {
                    Core.ui = 0;
                }
            }
        }).start();
    }

    public static boolean WebPlayerInstalled() {
        try {
            String jsonLibrary = Fs.ReadText(new File(String.valueOf(Options.container) + "portal/library.json"));
            JSONParser parser = new JSONParser();
            JSONObject libraryDat = (JSONObject)parser.parse(jsonLibrary);
            JSONObject apps = (JSONObject)libraryDat.get((Object)"apps");
            JSONObject webplayer = (JSONObject)apps.get((Object)"webplayer");
            String appLocation = webplayer.get((Object)"appFolder").toString();
            if (appLocation == null || appLocation.equals("")) {
                throw new Exception("webplayer not installed via Portal");
            }
            if (!appLocation.endsWith("/") && !appLocation.endsWith("\\")) {
                appLocation = String.valueOf(appLocation) + "/";
            }
            if (!new File(String.valueOf(appLocation) + "player.exe").exists()) {
                throw new Exception("Could not find player.exe");
            }
            webPlayerexe = new File(String.valueOf(appLocation) + "player.exe").getAbsolutePath();
            Analytics.Warn("Found installed webplayer in Lumonality Launcher");
            return true;
        }
        catch (Exception e) {
            if (new File(String.valueOf(Options.container) + "portal/app/webplayer/player.exe").exists()) {
                webPlayerexe = new File(String.valueOf(Options.container) + "portal/app/webplayer/player.exe").getAbsolutePath();
                return true;
            }
            return false;
        }
    }

    public static boolean OpenWebPlayer(String url) {
        return Web.OpenWebPlayer(url, 960, 540);
    }

    public static boolean OpenWebPlayer(final String url, final int width, final int height) {
        if (Web.WebPlayerInstalled()) {
            ThreadManager.Start(ThreadManager.Create(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList<String> args = new ArrayList<String>();
                        args.add(webPlayerexe);
                        args.add("-url=" + url);
                        args.add("-width=" + width);
                        args.add("-height=" + height);
                        String dataLoc = String.valueOf(Options.cache) + Tools.RandomSafeChars(24);
                        args.add("--user-data-dir=" + dataLoc);
                        ProcessBuilder pb = new ProcessBuilder(args);
                        pb.directory(new File(webPlayerexe).getParentFile());
                        pb.start();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            })));
            return true;
        }
        return false;
    }
}

