/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.ui;

import com.arizotaz.core.Core;
import com.arizotaz.core.Engine;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.ui.UIElement;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.Mouse;

public class Button
extends UIElement {
    protected String text = "";
    protected float x = 0.0f;
    protected float y = 0.0f;
    protected float width = 140.0f;
    protected float height = 50.0f;
    protected boolean hover = false;
    protected boolean allowHold = false;
    protected Text textObj;
    protected int r = 230;
    protected int g = 230;
    protected int b = 230;
    protected int tr = 0;
    protected int tg = 0;
    protected int tb = 0;
    protected float fontSize = 0.0f;
    protected boolean lightMode = Core.LightMode();
    protected boolean pressed = false;

    public Button() {
        this.Setup(Core.LightMode());
    }

    public Button(boolean lightMode) {
        this.Setup(lightMode);
    }

    private void Setup(boolean lightMode) {
        this.lightMode = lightMode;
        this.textObj = new Text("");
        this.textObj.Align(1, 1);
    }

    @Override
    public void Render() {
        this.pressed = false;
        if (Mouse.x - (double)Options.translateX - (double)this.x <= (double)(0.0f + this.width / 2.0f) && Mouse.x - (double)Options.translateX - (double)this.x >= (double)(0.0f - this.width / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y <= (double)(0.0f + this.height / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y >= (double)(0.0f - this.height / 2.0f)) {
            Mouse.cursorTexture = "pointer";
            this.hover = true;
            if (Mouse.clicked && !Engine.blockButtons) {
                this.pressed = true;
            }
        } else {
            this.hover = false;
        }
        if (this.selected && KeyboardInput.isPressed(257)) {
            this.pressed = true;
        }
        this.design();
    }

    protected void design() {
        float lineHeight = this.height;
        lineHeight = Tools.clampVar(lineHeight, 1.0f, this.height);
        RenderObjects.setColor(255 - this.r, 255 - this.g, 255 - this.b, 80.0f);
        RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width, lineHeight, lineHeight / 8.0f, 3);
        RenderObjects.setColor(this.r, this.g, this.b);
        if (this.hover) {
            this.r += 10;
            this.g += 10;
            this.b += 10;
            RenderObjects.drawRect(this.x, this.y, 0.0f, 0.0f, 0.0f);
        }
        if (this.lightMode) {
            RenderObjects.setColor(this.r, this.g, this.b);
        } else {
            RenderObjects.setColor(255 - this.r, 255 - this.g, 255 - this.b);
        }
        RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width - lineHeight / 8.0f, lineHeight - lineHeight / 8.0f, lineHeight / 8.0f, 3);
        if (this.selected) {
            RenderObjects.setColor(255.0f, 255.0f, 255.0f, 150.0f);
            RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width + lineHeight / 8.0f, lineHeight + lineHeight / 8.0f, lineHeight / 8.0f, 3);
        }
        float padding = 0.0f;
        padding = this.height / 3.0f;
        float textSize = this.height - padding;
        if (this.fontSize != 0.0f) {
            textSize = this.fontSize;
        }
        this.textObj.SetText(this.text);
        this.textObj.Color(this.tr, this.tg, this.tb, 255);
        if (!this.lightMode) {
            this.textObj.Color(255 - this.tr, 255 - this.tg, 255 - this.tb, 255);
        }
        this.textObj.FontSize(textSize);
        this.textObj.Render(this.x, this.y);
    }

    public boolean IsClicked() {
        return this.pressed;
    }

    public boolean IsDown() {
        return this.hover && Mouse.left;
    }

    public boolean IsHovering() {
        return this.hover;
    }

    public void Set(String _text, float _x, float _y, float _width, float _height) {
        UIElement.elements.add(this);
        this.text = _text;
        this.x = _x;
        this.y = _y;
        this.width = _width;
        this.height = _height;
    }

    public void LightMode(boolean value) {
        this.lightMode = value;
    }

    public void SetColor(int _r, int _g, int _b) {
        this.r = _r;
        this.g = _g;
        this.b = _b;
    }

    public void SetTextColor(int _r, int _g, int _b) {
        this.tr = _r;
        this.tg = _g;
        this.tb = _b;
    }

    public void FontSize(float fontSize) {
        this.fontSize = fontSize;
    }
}

