/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.ui;

import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.ui.Button;

public class CheckBox
extends Button {
    boolean value = false;

    public CheckBox() {
        this.SET();
    }

    public CheckBox(boolean lightMode) {
        super(lightMode);
        this.SET();
    }

    private void SET() {
        this.textObj.Align(0, 1);
        this.tr = 0;
        this.tg = 0;
        this.tb = 0;
    }

    public void Render(boolean value) {
        this.value = value;
        super.Render();
    }

    @Override
    protected void design() {
        if (this.value) {
            RenderObjects.setColor(120.0f);
            if (!this.lightMode) {
                RenderObjects.setColor(135.0f);
            }
        } else {
            RenderObjects.setColor(80.0f);
            if (!this.lightMode) {
                RenderObjects.setColor(175.0f);
            }
        }
        RenderObjects.drawRect(this.x, this.y, this.width, this.width, 0.0f);
        RenderObjects.setColor(50.0f);
        if (!this.lightMode) {
            RenderObjects.setColor(205.0f);
        }
        RenderObjects.drawRect(this.x, this.y, this.width - this.width / 10.0f, this.width - this.width / 10.0f, 0.0f);
        RenderObjects.setColor(255.0f);
        if (!this.lightMode) {
            RenderObjects.setColor(0.0f);
        }
        if (this.value) {
            RenderObjects.drawImage("checkbox_checked", this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        } else {
            RenderObjects.drawImage("checkbox_unchecked", this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        }
        if (this.selected) {
            RenderObjects.setColor(255.0f, 255.0f, 255.0f, 100.0f);
            if (!this.lightMode) {
                RenderObjects.setColor(0.0f, 0.0f, 0.0f, 100.0f);
            }
            RenderObjects.drawRect(this.x, this.y, this.width - this.width / 8.0f, this.width - this.width / 8.0f, 0.0f);
        }
        float padding = 0.0f;
        padding = this.height / 3.0f;
        float textSize = this.height - padding;
        if (this.fontSize != 0.0f) {
            textSize = this.fontSize;
        }
        this.textObj.FontSize(textSize);
        this.textObj.SetText(this.text);
        this.textObj.Color(this.tr, this.tg, this.tb, 255);
        if (!this.lightMode) {
            this.textObj.Color(255 - this.tr, 255 - this.tg, 255 - this.tb, 255);
        }
        this.textObj.Render(this.width / 2.0f + this.width / 8.0f + this.x, this.y);
    }
}

