/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.ui;

import com.arizotaz.Boot;
import com.arizotaz.core.Core;
import com.arizotaz.core.Engine;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.ui.UIElement;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.KeyboardTextInput;
import com.arizotaz.core.window.Mouse;
import java.time.LocalDateTime;
import org.lwjgl.glfw.GLFW;

public class InputField
extends UIElement {
    String value = "";
    float x = 0.0f;
    float y = 0.0f;
    float width = 140.0f;
    float height = 50.0f;
    protected String placeHolder = "";
    protected boolean lastState = false;
    protected static int[] keys = new int[512];
    protected boolean hideInput = false;
    Text textObj;
    protected int r = 0;
    protected int g = 0;
    protected int b = 0;
    protected int a = 255;
    protected int pr = 0;
    protected int pg = 0;
    protected int pb = 0;
    protected int pa = 128;
    protected boolean lightMode = true;

    public InputField() {
        this.Setup(Core.LightMode(), "");
    }

    public InputField(String placeHolder) {
        this.Setup(Core.LightMode(), placeHolder);
    }

    public InputField(boolean lightMode) {
        this.Setup(lightMode, "");
    }

    public InputField(String placeHolder, boolean lightMode) {
        this.Setup(lightMode, placeHolder);
    }

    private void Setup(boolean lightMode, String placeHolder) {
        this.lightMode = lightMode;
        this.placeHolder = placeHolder;
        this.textObj = new Text("");
        this.textObj.Align(0, 1);
    }

    @Override
    public void Render() {
        if (Mouse.left) {
            if (Mouse.x - (double)Options.translateX - (double)this.x <= (double)(0.0f + this.width / 2.0f) && Mouse.x - (double)Options.translateX - (double)this.x >= (double)(0.0f - this.width / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y <= (double)(0.0f + this.height / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y >= (double)(0.0f - this.height / 2.0f)) {
                if (!Engine.blockInputField) {
                    this.selected = true;
                }
            } else {
                this.selected = false;
            }
        }
        if (this.selected != this.lastState) {
            KeyboardTextInput.characters = "";
            this.lastState = this.selected;
        }
        if (this.selected) {
            this._key(86);
            this._key(67);
            this._key(8);
            this._key(259);
            this._key(257);
            this.value = String.valueOf(this.value) + KeyboardTextInput.characters;
            KeyboardTextInput.characters = "";
        }
        this.design();
    }

    public void design() {
        if (Core.debugMenu) {
            if (this.lightMode) {
                RenderObjects.setColor(51.0f);
            } else {
                RenderObjects.setColor(204.0f);
            }
            RenderObjects.drawRect(this.x, this.y, this.width, this.height, 0.0f);
        }
        if (this.lightMode) {
            RenderObjects.setColor(25.0f, 25.0f, 25.0f, 200.0f);
        } else {
            RenderObjects.setColor(230.0f, 230.0f, 230.0f, 200.0f);
        }
        float lineHeight = this.height / 20.0f;
        RenderObjects.drawRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, this.width, lineHeight, 0.0f);
        if (this.selected) {
            RenderObjects.setColor(0.0f, 0.0f, 0.0f, 100.0f);
            if (!this.lightMode) {
                RenderObjects.setColor(255.0f, 255.0f, 255.0f, 100.0f);
            }
            RenderObjects.drawRect(this.x, this.y, this.width, this.height, 0.0f);
        }
        RenderObjects.setColor(0.0f);
        float padding = 0.0f;
        padding = this.height / 3.0f;
        int _r = Text.r;
        int _g = Text.g;
        int _b = Text.b;
        int _a = Text.a;
        if (this.value.length() <= 0) {
            if (this.placeHolder.length() > 0) {
                this.textObj.Color(this.pr, this.pg, this.pb, this.pa);
                if (!this.lightMode) {
                    this.textObj.Color(255 - this.pr, 255 - this.pg, 255 - this.pb, this.pa);
                }
                this.textObj.SetText(this.placeHolder);
                this.textObj.FontSize(this.height - padding);
                this.textObj.AllowWrap(false);
                this.textObj.Calculate();
                boolean done = false;
                String text = "";
                int index = this.placeHolder.length() - 1;
                char[] chars = this.placeHolder.toCharArray();
                while (!done) {
                    StringBuilder stringBuilder = new StringBuilder(String.valueOf(chars[index]));
                    if (this.textObj.GetStringLength(stringBuilder.append(text).toString()) < this.width) {
                        text = String.valueOf(chars[index]) + text;
                        if (--index >= 0) continue;
                        done = true;
                        continue;
                    }
                    done = true;
                }
                this.textObj.SetText(text);
                this.textObj.MaxWidth(this.width - this.height / 4.0f * 2.0f);
                this.textObj.Render(this.x - this.width / 2.0f + this.height / 4.0f, this.y);
            }
        } else {
            this.textObj.Color(this.r, this.g, this.b, this.a);
            if (!this.lightMode) {
                this.textObj.Color(255 - this.r, 255 - this.g, 255 - this.b, this.a);
            }
            this.textObj.SetText(this.value);
            this.textObj.FontSize(this.height - padding);
            this.textObj.AllowWrap(false);
            this.textObj.Calculate();
            boolean done = false;
            String text = "";
            int index = this.value.length() - 1;
            char[] chars = this.value.toCharArray();
            if (this.hideInput) {
                int i = 0;
                while (i < chars.length) {
                    chars[i] = 42;
                    ++i;
                }
            }
            while (!done) {
                float spaceWidth = (float)(text.split(" ").length - 1) * this.textObj.GetSpaceWidth() * this.textObj.GetFontSize();
                StringBuilder stringBuilder = new StringBuilder(String.valueOf(chars[index]));
                if (this.textObj.GetStringLength(stringBuilder.append(text).toString()) + spaceWidth < this.width) {
                    text = String.valueOf(chars[index]) + text;
                    if (--index >= 0) continue;
                    done = true;
                    continue;
                }
                done = true;
            }
            this.textObj.SetText(text);
            this.textObj.MaxWidth(this.width - this.height / 4.0f * 2.0f);
            this.textObj.Render(this.x - this.width / 2.0f + this.height / 4.0f, this.y);
            if (this.textObj.GetSelectedIndex() >= 0) {
                System.out.println(this.textObj.GetSelectedIndex());
            }
            if (this.selected) {
                LocalDateTime date = LocalDateTime.now();
                if (date.getSecond() % 2 == 0) {
                    RenderObjects.drawRect(this.x - this.width / 2.0f + this.textObj.Width(), this.y, this.height / 10.0f, this.height - this.height / 5.0f, 0.0f);
                } else {
                    RenderObjects.setColor(0.0f, 0.0f, 0.0f, 0.0f);
                    RenderObjects.drawRect(this.x - this.width / 2.0f + this.height / 4.0f + this.textObj.Width(), this.y, this.height / 5.0f, this.height - this.height / 5.0f, 0.0f);
                }
            }
        }
        Text.setColor(_r, _g, _b, _a);
    }

    private void _key(int i) {
        if ((i == 8 || i == 259) && KeyboardInput.isPressed(i) && this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
            RenderObjects.drawRect(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (KeyboardInput.isKeyDown(i)) {
            if (keys[i] == 0) {
                if (i == 257) {
                    this.value = String.valueOf(this.value) + "\n";
                }
                if (i == 86 && (KeyboardInput.isKeyDown(341) || KeyboardInput.isKeyDown(343))) {
                    this.value = String.valueOf(this.value) + GLFW.glfwGetClipboardString((long)Boot.window).toString();
                }
                if (i == 67 && (KeyboardInput.isKeyDown(341) || KeyboardInput.isKeyDown(343))) {
                    GLFW.glfwSetClipboardString((long)Boot.window, (CharSequence)this.value);
                }
            }
            InputField.keys[i] = 1;
        }
        if (keys[i] != 0) {
            int n = i;
            keys[n] = keys[n] + 1;
            if (keys[i] == 3) {
                InputField.keys[i] = 0;
            }
        }
    }

    public void Set(float _x, float _y, float _width, float _height) {
        UIElement.elements.add(this);
        this.x = _x;
        this.y = _y;
        this.width = _width;
        this.height = _height;
    }

    public void Color(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public void PlaceHolderColor(int r, int g, int b, int a) {
        this.pr = r;
        this.pg = g;
        this.pb = b;
        this.pa = a;
    }

    public void LightMode(boolean value) {
        this.lightMode = value;
    }

    public void PlaceHolder(String value) {
        this.placeHolder = value;
    }

    public void HideInput(boolean value) {
        this.hideInput = value;
    }

    public boolean Selected() {
        return this.selected;
    }

    public void SetValue(String _value) {
        this.value = _value;
    }

    public void ResetValue() {
        this.value = "";
    }

    public String GetValue() {
        return this.value;
    }
}

