/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.ui;

import com.arizotaz.Boot;
import com.arizotaz.core.Core;
import com.arizotaz.core.Engine;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.ui.UIElement;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.KeyboardTextInput;
import com.arizotaz.core.window.Mouse;
import org.lwjgl.glfw.GLFW;

public class TextArea
extends UIElement {
    private String value = "";
    private float x = 0.0f;
    private float y = 0.0f;
    private float width = 140.0f;
    private float height = 50.0f;
    private String placeHolder = "";
    private boolean selected = false;
    private boolean lastState = false;
    private static int[] keys = new int[512];
    private float textSize = 0.0f;
    private int r = 230;
    private int g = 230;
    private int b = 230;
    private int tr = 0;
    private int tg = 0;
    private int tb = 0;
    private boolean hover = false;
    boolean lightMode = false;

    public TextArea() {
        this.Setup("", Core.LightMode());
    }

    public TextArea(String placeHolder) {
        this.Setup(placeHolder, Core.LightMode());
    }

    public TextArea(String placeHolder, boolean lightMode) {
        this.Setup(placeHolder, lightMode);
    }

    private void Setup(String placeHolder, boolean lightMode) {
        this.placeHolder = placeHolder;
        this.lightMode = lightMode;
    }

    @Override
    public void Render() {
        if (Mouse.left) {
            if (Mouse.x - (double)Options.translateX - (double)this.x <= (double)(0.0f + this.width / 2.0f) && Mouse.x - (double)Options.translateX - (double)this.x >= (double)(0.0f - this.width / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y <= (double)(0.0f + this.height / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y >= (double)(0.0f - this.height / 2.0f)) {
                if (!Engine.blockInputField) {
                    this.selected = true;
                }
            } else {
                this.selected = false;
            }
        }
        this.hover = Mouse.x - (double)Options.translateX - (double)this.x <= (double)(0.0f + this.width / 2.0f) && Mouse.x - (double)Options.translateX - (double)this.x >= (double)(0.0f - this.width / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y <= (double)(0.0f + this.height / 2.0f) && Mouse.y + (double)Options.translateY - (double)Options.heightOfScreen + (double)this.y >= (double)(0.0f - this.height / 2.0f);
        if (this.selected != this.lastState) {
            this.lastState = this.selected;
        }
        if (this.selected) {
            this._key(86);
            this._key(67);
            this._key(8);
            this._key(259);
            this._key(257);
            this.value = String.valueOf(this.value) + KeyboardTextInput.characters;
        }
        this.design();
    }

    public void design() {
        float size;
        float lineHeight = this.height;
        float padding = this.width / 8.0f;
        padding = Tools.clampVar(padding, 2.0f, 5.0f);
        RenderObjects.setColor(255 - this.r, 255 - this.g, 255 - this.b, 80.0f);
        RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width, this.height, 5.0, 3);
        RenderObjects.setColor(this.r, this.g, this.b);
        if (this.hover) {
            this.r += 10;
            this.g += 10;
            this.b += 10;
            RenderObjects.drawRect(0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        }
        if (this.lightMode) {
            RenderObjects.setColor(this.r, this.g, this.b);
        } else {
            RenderObjects.setColor(255 - this.r, 255 - this.g, 255 - this.b);
        }
        RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width - padding, this.height - padding, 5.0, 3);
        if (this.selected) {
            RenderObjects.setColor(255.0f, 255.0f, 255.0f, 150.0f);
            RenderObjects.drawRoundedRect(this.x, this.y - this.height / 2.0f + lineHeight / 2.0f, 0.0, this.width - padding, this.height - padding, 5.0, 3);
        }
        if ((size = this.textSize) == 0.0f) {
            size = Options.scl;
        }
        Text text = new Text(this.placeHolder);
        int opacity = 255;
        if (!this.value.equals("")) {
            text.SetText(this.value);
        } else {
            opacity = 200;
        }
        text.Color(this.tr, this.tg, this.tb, opacity);
        if (!this.lightMode) {
            text.Color(255 - this.tr, 255 - this.tg, 255 - this.tb, opacity);
        }
        text.Align(0, 0);
        text.MaxWidth(this.width - padding * 4.0f);
        text.Render(this.x - this.width / 2.0f + padding * 2.0f, this.y + this.height / 2.0f - padding * 2.0f);
    }

    private void _key(int i) {
        if ((i == 8 || i == 259) && KeyboardInput.isPressed(i) && this.value.length() > 0) {
            this.value = this.value.substring(0, this.value.length() - 1);
        }
        if (KeyboardInput.isKeyDown(i)) {
            if (keys[i] == 0) {
                if (i == 257) {
                    this.value = String.valueOf(this.value) + "\n";
                }
                if (i == 86 && (KeyboardInput.isKeyDown(341) || KeyboardInput.isKeyDown(343))) {
                    this.value = String.valueOf(this.value) + GLFW.glfwGetClipboardString((long)Boot.window).toString();
                }
                if (i == 67 && (KeyboardInput.isKeyDown(341) || KeyboardInput.isKeyDown(343))) {
                    GLFW.glfwSetClipboardString((long)Boot.window, (CharSequence)this.value);
                }
            }
            TextArea.keys[i] = 1;
        }
        if (keys[i] != 0) {
            int n = i;
            keys[n] = keys[n] + 1;
            if (keys[i] == 3) {
                TextArea.keys[i] = 0;
            }
        }
    }

    public void Set(float _x, float _y, float _width, float _height) {
        this.x = _x;
        this.y = _y;
        this.width = _width;
        this.height = _height;
    }

    public void SetColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public void SetTextColor(int r, int g, int b) {
        this.tr = r;
        this.tg = g;
        this.tb = b;
    }

    public void SetValue(String value) {
        this.value = value;
    }

    public String GetValue() {
        return this.value;
    }

    public float GetTextSize() {
        return this.textSize;
    }

    public void SetTextSize(float size) {
        this.textSize = size;
    }
}

