/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.window;

import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.window.TrayEvent;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.net.URL;

public class Tray {
    private final PopupMenu popup = new PopupMenu();
    private SystemTray tray = null;

    public Tray() {
        if (!SystemTray.isSupported()) {
            Core.banner("SystemTray is not supported");
        }
    }

    public void Setup() {
        if (this.tray != null) {
            Core.banner("Tray already exists");
            return;
        }
        if (!SystemTray.isSupported()) {
            Core.banner("SystemTray is not supported");
            return;
        }
        URL url = Options.class.getResource("/com/arizotaz/core/lumonality_tray.png");
        Image img = Toolkit.getDefaultToolkit().getImage(url);
        TrayIcon trayIcon = new TrayIcon(img, "Lumonality");
        this.tray = SystemTray.getSystemTray();
        trayIcon.setPopupMenu(this.popup);
        try {
            this.tray.add(trayIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
            Core.banner("TrayIcon could not be added.");
        }
    }

    public void Add(TrayEvent trayButton) {
        this.Insert(trayButton, 0);
    }

    public void Insert(TrayEvent trayButton, int index) {
        MenuItem button = new MenuItem(trayButton.text);
        button.addActionListener(trayButton);
        this.popup.insert(button, index);
    }

    public void Seperate() {
        this.Seperate(0);
    }

    public void Seperate(int index) {
        this.popup.insertSeparator(index);
    }
}

