/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.core.window;

import com.arizotaz.core.Boot;
import com.arizotaz.core.Core;
import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.Texture;
import com.arizotaz.core.reqs.BufferUtilities;
import com.arizotaz.core.reqs.TextureLoad;
import com.arizotaz.core.tools.ThreadManager;
import com.arizotaz.core.window.BootAnimation;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.KeyboardTextInput;
import com.arizotaz.core.window.Mouse;
import com.arizotaz.core.window.MouseScroll;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallbackI;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWKeyCallbackI;
import org.lwjgl.glfw.GLFWScrollCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class Window {
    public int monitorIndex = 0;
    public long window;
    private int width = 980;
    private int lastWidth = this.width / 16 * 9;
    private int height = this.width / 16 * 10;
    private int lastHeight = 0;
    private boolean resizeWindow = false;
    private boolean hideWindowOnClose = false;
    private boolean watermark = true;
    public double maxFPS;
    public double _setFPS = this.maxFPS = -1.0;
    private int fwidth = this.width / 4;
    private int fheight = this.height / 4;
    private int viewPortWidth = 0;
    private int viewPortHeight = 0;
    private int canvasWidth = 10;
    private int setCanvasWidth = 0;
    private boolean takeFocus = false;
    private double previousTime = GLFW.glfwGetTime();
    private int frameCount = 60;
    private double loopStartTime;
    private long currentMonitor;
    private boolean showEvent = false;
    private boolean hideEvent = false;
    private boolean isWindowHidden = false;
    long processTime = 0L;
    long lastProcessTime = 0L;
    long windowTime = 0L;
    long lastWindowTime = 0L;
    long renderTime = 0L;
    long lastRenderTime = 0L;
    private long frameTime = 0L;
    private long lastFPSCalc = 0L;
    private float fpsLow = 0.0f;
    private float fpsHigh = 0.0f;
    public boolean bootDone = false;
    public boolean booted = false;
    private int bootThread = -1;
    private String bootMessage = "";
    public BootAnimation ani = null;
    public boolean fullscreen = false;
    public int beforeFullscreenWidth = 0;
    public int beforeFullscreenHeight = 0;
    private boolean vsync = true;
    public int _vs = 1;
    public int _lvs = -1;
    int colorTexture;
    int fbo;
    int multisampledColorRenderBuffer;
    int multisampledDepthRenderBuffer;
    int multisampledFbo;
    int samples = 0;

    public int Width() {
        return this.width;
    }

    public int Height() {
        return this.height;
    }

    public boolean BootMenuActive() {
        return this.watermark;
    }

    public long init(int w, int h, boolean show) {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        com.arizotaz.Boot.window = this.window;
        this.width = w;
        this.lastWidth = 0;
        this.height = h;
        this.lastHeight = 0;
        this.CreateWindow();
        this.SetupInputs();
        this.SetupGL();
        this.createFBOs();
        try {
            this.SetIcon("com/arizotaz/core/lumonality.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (show) {
            GLFW.glfwShowWindow((long)this.window);
        }
        return this.window;
    }

    public long ProcessTime() {
        return this.processTime;
    }

    public long WindowTime() {
        return this.windowTime;
    }

    public long RenderTime() {
        return this.renderTime;
    }

    public void loop() {
        this.loop(true);
    }

    public void loop(boolean swap) {
        long time;
        this.processTime = System.currentTimeMillis() - this.lastProcessTime;
        this.lastProcessTime = System.currentTimeMillis();
        this.lastWindowTime = System.currentTimeMillis();
        this.CalculateFPS();
        KeyboardTextInput.characters = "";
        KeyboardInput.tickKeyUpdate();
        GLFW.glfwPollEvents();
        Options.widthOfScreen = this.width;
        Options.heightOfScreen = this.height;
        Mouse.tick(this.getCursorPosX(this.window) / (double)Options.winWidth * (double)this.width, this.getCursorPosY(this.window) / (double)Options.winHeight * (double)this.height, GLFW.glfwGetMouseButton((long)this.window, (int)0), GLFW.glfwGetMouseButton((long)this.window, (int)1));
        this.CanvasTick();
        Throwable throwable = null;
        Object var3_5 = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.currentMonitor = GLFW.glfwGetPrimaryMonitor();
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowPos((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            int cx = pWidth.get(0);
            int cy = pHeight.get(0);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            int cw = pWidth.get(0);
            int ch = pHeight.get(0);
            PointerBuffer glfwMonitors = GLFW.glfwGetMonitors();
            int i = 0;
            while (i < glfwMonitors.limit()) {
                IntBuffer v1 = stack.mallocInt(1);
                IntBuffer v2 = stack.mallocInt(1);
                GLFW.glfwGetMonitorPos((long)glfwMonitors.get(i), (IntBuffer)v1, (IntBuffer)v2);
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)glfwMonitors.get(i));
                int tx = v1.get(0);
                int ty = v2.get(0);
                int tw = vidmode.width();
                int th = vidmode.height();
                if (cx > tx && cx < tx + tw && cy > ty && cy < ty + th) {
                    this.monitorIndex = i;
                    this.currentMonitor = glfwMonitors.get(i);
                }
                ++i;
            }
            if (this.resizeWindow) {
                this.resizeWindow = false;
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)this.currentMonitor);
                GLFW.glfwGetWindowPos((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
                int oldX = pWidth.get(0);
                int oldY = pHeight.get(0);
                GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
                int oldWidth = pWidth.get(0);
                int oldHeight = pHeight.get(0);
                int posX = oldX - (this.width - oldWidth) / 2;
                int posY = oldY - (this.height - oldHeight) / 2;
                GLFW.glfwSetWindowSize((long)this.window, (int)this.width, (int)this.height);
                GLFW.glfwSetWindowPos((long)this.window, (int)posX, (int)posY);
            }
            GLFW.glfwGetFramebufferSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            this.width = pWidth.get(0);
            this.height = pHeight.get(0);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            Options.winWidth = pWidth.get(0);
            Options.winHeight = pHeight.get(0);
            if (this.takeFocus) {
                this.takeFocus = false;
                GLFW.glfwFocusWindow((long)this.window);
            }
            if (this.hideEvent) {
                this.hideEvent = !this.hideEvent;
                GLFW.glfwHideWindow((long)this.window);
                this.isWindowHidden = true;
            }
            if (this.showEvent) {
                this.showEvent = !this.showEvent;
                GLFW.glfwShowWindow((long)this.window);
                RenderObjects.ForceMapUpdate();
                this.isWindowHidden = false;
            }
            FloatBuffer scaleX = stack.mallocFloat(1);
            FloatBuffer scaleY = stack.mallocFloat(1);
            GLFW.glfwGetMonitorContentScale((long)this.currentMonitor, (FloatBuffer)scaleX, (FloatBuffer)scaleY);
            Options.contentScale = scaleX.get(0);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Options.windowResized = false;
        if (this.lastWidth != this.width || this.lastHeight != this.height) {
            this.lastWidth = this.width;
            this.lastHeight = this.height;
            this.canvasWidth = this.width;
            this.viewPortWidth = this.width;
            this.viewPortHeight = this.height;
            Options.windowResized = true;
            if (Options.maxAutoFocusSize != -1) {
                this.canvasWidth = Options.maxAutoFocusSize;
            }
            this.UpdateCanvas();
        }
        Options.canvasWidth = this.fwidth;
        Options.canvasHeight = this.fheight;
        this.lastRenderTime = System.currentTimeMillis();
        if (Boot.run) {
            if (!this.watermark) {
                if (RenderObjects.render) {
                    this._setFPS = this.maxFPS;
                }
                com.arizotaz.Boot.Tick();
                this.lastRenderTime = System.currentTimeMillis();
                GL30.glBindFramebuffer((int)36160, (int)this.multisampledFbo);
                if (RenderObjects.render) {
                    GL11.glClearColor((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                    GL11.glClear((int)16640);
                }
                GL11.glViewport((int)0, (int)0, (int)this.viewPortWidth, (int)this.viewPortHeight);
                GL30.glMatrixMode((int)5889);
                GL30.glLoadIdentity();
                GL30.glOrtho((double)0.0, (double)this.viewPortWidth, (double)0.0, (double)this.viewPortHeight, (double)0.0, (double)1.0);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                Mouse.tick(this.getCursorPosX(this.window) / (double)Options.winWidth * (double)this.fwidth, this.getCursorPosY(this.window) / (double)Options.winHeight * (double)this.fheight, GLFW.glfwGetMouseButton((long)this.window, (int)0), GLFW.glfwGetMouseButton((long)this.window, (int)1));
                Options.widthOfScreen = this.fwidth;
                Options.heightOfScreen = this.fheight;
                com.arizotaz.Boot.Render();
                if (RenderObjects.render) {
                    GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
                    GL30.glBindFramebuffer((int)36160, (int)0);
                    GL30.glBindFramebuffer((int)36008, (int)this.multisampledFbo);
                    GL30.glBindFramebuffer((int)36009, (int)this.fbo);
                    GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)this.width, (int)this.height, (int)16384, (int)9728);
                    GL30.glBindFramebuffer((int)36160, (int)0);
                    GL11.glEnable((int)3553);
                    GL11.glBindTexture((int)3553, (int)this.colorTexture);
                    GL11.glMatrixMode((int)5889);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glLoadIdentity();
                    GL11.glBegin((int)7);
                    GL11.glTexCoord2f((float)0.0f, (float)0.0f);
                    GL11.glVertex2f((float)-1.0f, (float)-1.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)0.0f);
                    GL11.glVertex2f((float)1.0f, (float)-1.0f);
                    GL11.glTexCoord2f((float)1.0f, (float)1.0f);
                    GL11.glVertex2f((float)1.0f, (float)1.0f);
                    GL11.glTexCoord2f((float)0.0f, (float)1.0f);
                    GL11.glVertex2f((float)-1.0f, (float)1.0f);
                    GL11.glEnd();
                }
                RenderObjects.lastImage = "";
                GL30.glMatrixMode((int)5889);
                GL30.glLoadIdentity();
                GL30.glOrtho((double)0.0, (double)this.width, (double)0.0, (double)this.height, (double)0.0, (double)1.0);
                Options.widthOfScreen = this.width;
                Options.heightOfScreen = this.height;
                com.arizotaz.Boot.RenderOuterCanvas();
                Mouse.tick(this.getCursorPosX(this.window) / (double)Options.winWidth * (double)this.width, this.getCursorPosY(this.window) / (double)Options.winHeight * (double)this.height, GLFW.glfwGetMouseButton((long)this.window, (int)0), GLFW.glfwGetMouseButton((long)this.window, (int)1));
                Core.renderOverlay();
            } else {
                GL11.glViewport((int)0, (int)0, (int)this.width, (int)this.height);
                GL30.glMatrixMode((int)5889);
                GL30.glLoadIdentity();
                GL30.glOrtho((double)0.0, (double)this.width, (double)0.0, (double)this.height, (double)0.0, (double)1.0);
                Options.widthOfScreen = this.width;
                Options.heightOfScreen = this.height;
                Mouse.tick(this.getCursorPosX(this.window) / (double)Options.winWidth * (double)this.width, this.getCursorPosY(this.window) / (double)Options.winHeight * (double)this.height, GLFW.glfwGetMouseButton((long)this.window, (int)0), GLFW.glfwGetMouseButton((long)this.window, (int)1));
                this.bootAnimation();
                Core.renderOverlay();
            }
            if (GLFW.glfwWindowShouldClose((long)this.window)) {
                if (!KeyboardInput.isKeyDown(340)) {
                    if (this.hideWindowOnClose) {
                        this.Hide();
                        GLFW.glfwSetWindowShouldClose((long)this.window, (boolean)false);
                    } else {
                        Boot.run = false;
                    }
                } else {
                    System.out.println("Killing Process");
                    this.quit();
                    System.exit(1);
                }
            }
        }
        if (swap && RenderObjects.render) {
            this.Swap();
        }
        this.renderTime = System.currentTimeMillis() - this.lastRenderTime;
        if (this._setFPS > 0.0 && (time = (long)((this.loopStartTime - GLFW.glfwGetTime() + 1.0 / this._setFPS) * 1000.0)) > 0L) {
            try {
                Thread.sleep(time);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (this._vs != this._lvs) {
            this._lvs = this._vs;
            GLFW.glfwSwapInterval((int)this._vs);
            this.vsync = this._vs > 0;
        }
        this.windowTime = System.currentTimeMillis() - this.lastWindowTime;
    }

    public void Swap() {
        GLFW.glfwSwapBuffers((long)this.window);
        this.frameTime = System.nanoTime() - this.lastFPSCalc;
        this.lastFPSCalc = System.nanoTime();
    }

    private void CreateWindow() {
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)2);
        GLFW.glfwWindowHint((int)139267, (int)0);
        GLFW.glfwWindowHint((int)139276, (int)1);
        this.window = GLFW.glfwCreateWindow((int)this.width, (int)this.height, (CharSequence)"Window", (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
    }

    private void SetupGL() {
        GL.createCapabilities();
        this.setTitle("Window");
        GL11.glEnable((int)3553);
    }

    private void SetupInputs() {
        GLFW.glfwSetKeyCallback((long)this.window, (GLFWKeyCallbackI)new KeyboardInput());
        GLFW.glfwSetCharCallback((long)this.window, (GLFWCharCallbackI)new KeyboardTextInput());
        GLFW.glfwSetScrollCallback((long)this.window, (GLFWScrollCallbackI)new MouseScroll());
    }

    private void CalculateFPS() {
        if (this.frameTime > 0L) {
            Options.fps = Math.round(1000.0f / ((float)this.frameTime / 1000000.0f));
        }
        if (Options.fps > this.fpsHigh) {
            this.fpsHigh = Options.fps;
        }
        if (Options.fps < this.fpsLow || this.fpsLow == 0.0f) {
            this.fpsLow = Options.fps;
        }
        this.loopStartTime = GLFW.glfwGetTime();
        double currentTime = GLFW.glfwGetTime();
        ++this.frameCount;
        if (currentTime - this.previousTime >= 1.0) {
            Options.fpsAverage = this.frameCount;
            Options.fpsHigh = this.fpsHigh;
            Options.fpsLow = this.fpsLow;
            this.fpsLow = 0.0f;
            this.fpsHigh = 0.0f;
            this.frameCount = 0;
            this.previousTime = currentTime;
        }
    }

    private void CanvasTick() {
        if (Options.autoFocus && RenderObjects.render) {
            if (Options.fps < 30.0f && this.canvasWidth > Options.minAutoFocusSize) {
                this.canvasWidth -= 10;
                this.UpdateCanvas();
            }
            if (Options.fps > 35.0f) {
                int manCanv = this.width;
                if (Options.maxAutoFocusSize != -1 && Options.minAutoFocusSize > (manCanv = Options.maxAutoFocusSize)) {
                    manCanv = Options.minAutoFocusSize;
                }
                if (this.canvasWidth < manCanv) {
                    this.canvasWidth += 10;
                    if (this.canvasWidth > this.width) {
                        this.width = this.canvasWidth;
                    }
                    this.UpdateCanvas();
                }
            }
        }
        if (this.setCanvasWidth > 0) {
            this.canvasWidth = this.setCanvasWidth;
            this.setCanvasWidth = 0;
            if (Options.maxAutoFocusSize != -1) {
                this.canvasWidth = Options.maxAutoFocusSize;
            }
            this.UpdateCanvas();
        }
    }

    private void bootAnimation() {
        Options.canvasWidth = this.width;
        Options.canvasHeight = this.height;
        Options.setTranslate(this.width / 2, this.height / 2);
        int textColor = 255;
        RenderObjects.setColor(0.0f);
        RenderObjects.drawRect(0.0f, 0.0f, this.width, this.height, 0.0f);
        float logoWidth = 1.0f;
        float logoHeight = 1.0f;
        try {
            String texture = "lumonality_logo";
            float size = (float)this.height / 3.0f;
            Texture tex = Texture.textures.get(texture);
            logoWidth = size;
            logoHeight = size / (float)tex.width * (float)tex.height;
            RenderObjects.setColor(255.0f);
            RenderObjects.allowStretch = true;
            RenderObjects.drawImage(texture, (float)(-this.width / 2) + logoWidth / 2.0f, (float)(this.height / 2) - logoHeight / 2.0f, logoWidth, logoHeight, 0.0f);
            size = logoHeight;
        }
        catch (Exception e) {
            Text.setColor(255);
            Text.render("Loading", 0.0f, 0.0f, 12.0f, 1000, 1);
        }
        Text.setColor(255);
        Text.render("Lumonality Core " + Core.Version(), (float)(-this.width / 2) + logoWidth * 1.2f, (float)(this.height / 2) - logoHeight / 2.0f, logoHeight / 10.0f, 1000, 0);
        Text.render(this.bootMessage, (float)(-this.width / 2) + logoWidth / 10.0f, (float)(this.height / 2) - logoHeight, 24.0f, 100, 0);
        Text.setColor(textColor);
        if (textColor < 255) {
            Text.setColor(200, 0, 255);
        }
        Text.render("V" + Core.Version(), 0.0f, -logoHeight - 55.0f - 60.0f, 15.0f, 1000, 1);
        Text.setColor(textColor);
        Text.render(Core.status, 0.0f, -this.height / 2 + 15, 20.0f, 1000, 1);
        if (!Boot.DebugMode() && this.ani != null) {
            this.ani.Render();
        }
        if (this.bootThread == -1) {
            this.bootThread = ThreadManager.Create("BootThread", new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!Boot.DebugMode() && Window.this.ani != null) {
                            Window.this.ani.Wake();
                        }
                        Window.this.bootMessage = "Starting Core\n" + Window.this.bootMessage;
                        Core.status = "Starting Core";
                        Window.this.bootMessage = "Clearing Cache\n" + Window.this.bootMessage;
                        Core.checkCache();
                        Window.this.bootMessage = "Loading Assets\n" + Window.this.bootMessage;
                        while (TextureLoad.needLoaded.size() > 0 && Boot.run) {
                            Thread.sleep(1L);
                        }
                        Window.this.bootMessage = "Downloading Assets\n" + Window.this.bootMessage;
                        Core.loadAssets();
                        Window.this.bootMessage = "Starting Application\n" + Window.this.bootMessage;
                        Core.status = "Starting Application";
                        com.arizotaz.Boot.AppStart();
                        Core.status = "Done";
                        Window.this.bootMessage = "Done\n" + Window.this.bootMessage;
                        if (System.getProperty("fullscreen") != null) {
                            Window.this.fullscreen(true);
                        }
                        Window.this.watermark = false;
                        Window.this.bootDone = true;
                        if (Boot.DebugMode()) {
                            Core.showDebug = true;
                            Core.debugMenu = true;
                        }
                    }
                    catch (Exception e) {
                        Core.status = e.toString();
                        try {
                            Thread.sleep(15000L);
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                        }
                        Core.Crash(e.toString());
                    }
                }
            }));
            ThreadManager.Start(this.bootThread);
        }
    }

    public void quit() {
        Callbacks.glfwFreeCallbacks((long)this.window);
        GLFW.glfwDestroyWindow((long)this.window);
    }

    public void setTitle(String string) {
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)string);
    }

    public double getCursorPosX(long windowID) {
        DoubleBuffer posX = BufferUtils.createDoubleBuffer((int)1);
        GLFW.glfwGetCursorPos((long)windowID, (DoubleBuffer)posX, null);
        return posX.get(0);
    }

    public double getCursorPosY(long windowID) {
        DoubleBuffer posY = BufferUtils.createDoubleBuffer((int)1);
        GLFW.glfwGetCursorPos((long)windowID, null, (DoubleBuffer)posY);
        return posY.get(0);
    }

    public boolean IsHidden() {
        return this.isWindowHidden;
    }

    public void Hide() {
        this.hideEvent = true;
    }

    public void Show() {
        this.showEvent = true;
    }

    public void HideOnClose(boolean val) {
        this.hideWindowOnClose = val;
    }

    public void toggleFullscreen() {
        this.fullscreen(!this.fullscreen);
    }

    public void fullscreen(boolean value) {
        block20: {
            this.fullscreen = value;
            if (this.fullscreen) {
                this.beforeFullscreenWidth = Math.round(Options.winWidth);
                this.beforeFullscreenHeight = Math.round(Options.winHeight);
                Throwable throwable = null;
                Object var3_6 = null;
                try (MemoryStack stack = MemoryStack.stackPush();){
                    IntBuffer pWidth = stack.mallocInt(1);
                    IntBuffer pHeight = stack.mallocInt(1);
                    IntBuffer x = stack.mallocInt(1);
                    IntBuffer y = stack.mallocInt(1);
                    this.border(false);
                    GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)this.currentMonitor);
                    GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
                    this.setWindowSize(vidmode.width(), vidmode.height());
                    break block20;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            if (this.beforeFullscreenWidth == 0 || this.beforeFullscreenHeight == 0) {
                this.beforeFullscreenWidth = 960;
                this.beforeFullscreenHeight = 540;
            }
            GLFW.glfwSetWindowMonitor((long)this.window, (long)0L, (int)0, (int)0, (int)this.beforeFullscreenWidth, (int)this.beforeFullscreenHeight, (int)-1);
            Throwable throwable = null;
            Object var3_8 = null;
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer pWidth = stack.mallocInt(1);
                IntBuffer pHeight = stack.mallocInt(1);
                GLFW.glfwGetWindowSize((long)this.window, (IntBuffer)pWidth, (IntBuffer)pHeight);
                this.border(true);
                GLFWVidMode vidmode = GLFW.glfwGetVideoMode((long)this.currentMonitor);
                GLFW.glfwSetWindowPos((long)this.window, (int)((vidmode.width() - pWidth.get(0)) / 2), (int)((vidmode.height() - pHeight.get(0)) / 2));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
    }

    public boolean Vsync() {
        return this.vsync;
    }

    public void useVsync(boolean yes) {
        this._vs = yes ? 1 : 0;
    }

    public void setWindowSize(int w, int h) {
        this.resizeWindow = true;
        this.width = w;
        this.height = h;
    }

    public void border(boolean on) {
        if (on) {
            GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)1);
        } else {
            GLFW.glfwSetWindowAttrib((long)this.window, (int)131077, (int)0);
        }
    }

    public void minimize() {
        GLFW.glfwIconifyWindow((long)this.window);
    }

    public void minimizeRestore() {
        GLFW.glfwRestoreWindow((long)this.window);
    }

    public void getAttention() {
        GLFW.glfwRequestWindowAttention((long)this.window);
    }

    public void focus() {
        this.takeFocus = true;
    }

    public void setFPS(int val) {
        this.maxFPS = val;
    }

    public void setCanvasSize(int width) {
        this.setCanvasWidth = width;
    }

    public int canvasWidth() {
        return this.canvasWidth;
    }

    void UpdateCanvas() {
        this.fwidth = this.canvasWidth;
        this.fheight = Math.round((float)this.height / (float)this.width * (float)this.fwidth);
        this.resizeFBOs();
    }

    public int multisampledFbo() {
        return this.multisampledFbo;
    }

    void createFBOs() {
        this.multisampledColorRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledDepthRenderBuffer = GL30.glGenRenderbuffers();
        this.multisampledFbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.multisampledFbo);
        GL30.glBindRenderbuffer((int)36161, (int)this.multisampledColorRenderBuffer);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)32856, (int)this.fwidth, (int)this.fheight);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36064, (int)36161, (int)this.multisampledColorRenderBuffer);
        GL30.glBindRenderbuffer((int)36161, (int)this.multisampledDepthRenderBuffer);
        GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)35056, (int)this.fwidth, (int)this.fheight);
        GL30.glFramebufferRenderbuffer((int)36160, (int)36096, (int)36161, (int)this.multisampledDepthRenderBuffer);
        int fboStatus = GL30.glCheckFramebufferStatus((int)36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
        this.colorTexture = GL11.glGenTextures();
        this.fbo = GL30.glGenFramebuffers();
        GL30.glBindFramebuffer((int)36160, (int)this.fbo);
        GL11.glBindTexture((int)3553, (int)this.colorTexture);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.fwidth, (int)this.fheight, (int)0, (int)6408, (int)5121, null);
        GL30.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)this.colorTexture, (int)0);
        fboStatus = GL30.glCheckFramebufferStatus((int)36160);
        if (fboStatus != 36053) {
            return;
        }
        GL30.glBindRenderbuffer((int)36161, (int)0);
        GL30.glBindFramebuffer((int)36160, (int)0);
    }

    void resizeFBOs() {
        GL30.glDeleteRenderbuffers((int)this.multisampledDepthRenderBuffer);
        GL30.glDeleteRenderbuffers((int)this.multisampledColorRenderBuffer);
        GL30.glDeleteFramebuffers((int)this.multisampledFbo);
        GL11.glDeleteTextures((int)this.colorTexture);
        GL30.glDeleteFramebuffers((int)this.fbo);
        this.createFBOs();
    }

    public void SetIcon(String path) throws Exception {
        ByteBuffer icon32;
        ByteBuffer icon16;
        IntBuffer w = MemoryUtil.memAllocInt((int)1);
        IntBuffer h = MemoryUtil.memAllocInt((int)1);
        IntBuffer comp = MemoryUtil.memAllocInt((int)1);
        try {
            icon16 = this.ioResourceToByteBuffer(path, 2048);
            icon32 = this.ioResourceToByteBuffer(path, 4096);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Throwable throwable = null;
        Object var8_10 = null;
        try (GLFWImage.Buffer icons = GLFWImage.malloc((int)2);){
            ByteBuffer pixels16 = STBImage.stbi_load_from_memory((ByteBuffer)icon16, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)4);
            ((GLFWImage.Buffer)icons.position(0)).width(w.get(0)).height(h.get(0)).pixels(pixels16);
            ByteBuffer pixels32 = STBImage.stbi_load_from_memory((ByteBuffer)icon32, (IntBuffer)w, (IntBuffer)h, (IntBuffer)comp, (int)4);
            ((GLFWImage.Buffer)icons.position(1)).width(w.get(0)).height(h.get(0)).pixels(pixels32);
            icons.position(0);
            GLFW.glfwSetWindowIcon((long)this.window, (GLFWImage.Buffer)icons);
            STBImage.stbi_image_free((ByteBuffer)pixels32);
            STBImage.stbi_image_free((ByteBuffer)pixels16);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        MemoryUtil.memFree((Buffer)comp);
        MemoryUtil.memFree((Buffer)h);
        MemoryUtil.memFree((Buffer)w);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        block22: {
            Path path = Paths.get(resource, new String[0]);
            if (Files.isReadable(path)) {
                Throwable throwable = null;
                Object var6_8 = null;
                try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                    buffer = BufferUtils.createByteBuffer((int)((int)fc.size() + 1));
                    while (fc.read(buffer) != -1) {
                    }
                    break block22;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            Throwable throwable = null;
            Object var6_10 = null;
            try {
                InputStream source = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                try {
                    try (ReadableByteChannel rbc = Channels.newChannel(source);){
                        int bytes;
                        buffer = BufferUtils.createByteBuffer((int)bufferSize);
                        while ((bytes = rbc.read(buffer)) != -1) {
                            if (buffer.remaining() != 0) continue;
                            buffer = BufferUtilities.resizeBuffer(buffer, buffer.capacity() * 2);
                        }
                    }
                    if (source == null) break block22;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (source == null) throw throwable;
                    source.close();
                    throw throwable;
                }
                source.close();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        buffer.flip();
        return buffer;
    }

    public void SetViewPortSize(int w, int h) {
        this.viewPortWidth = w;
        this.viewPortHeight = h;
    }

    public int ViewPortWidth() {
        return this.viewPortWidth;
    }

    public int ViewPortHeight() {
        return this.viewPortHeight;
    }

    public void ResizeFrame() {
        this.lastWidth = 0;
        this.lastHeight = 0;
    }

    public void SaveImage(File file) {
        GL11.glReadBuffer((int)this.multisampledFbo);
        int width = this.viewPortWidth;
        int height = this.viewPortHeight;
        int bpp = 4;
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * bpp));
        GL11.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)buffer);
        String format = "png";
        BufferedImage image = new BufferedImage(width, height, 2);
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int i = (x + width * y) * bpp;
                int r = buffer.get(i) & 0xFF;
                int g = buffer.get(i + 1) & 0xFF;
                int b = buffer.get(i + 2) & 0xFF;
                image.setRGB(x, height - (y + 1), 0xFF000000 | r << 16 | g << 8 | b);
                ++y;
            }
            ++x;
        }
        try {
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

