/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.firelab;

import com.arizotaz.firelab.Shader;
import java.io.IOException;
import org.lwjgl.opengl.GL20;

public class Normal {
    int normalProgram;
    int normalProgramBiasUniform;
    int normalProgramVPUniform;
    int normalProgramLVPUniform;
    int normalProgramLightPosition;
    int normalProgramLightLookAt;
    int samplerLocation;

    public Normal() throws IOException {
        this.createNormalProgram();
    }

    void createNormalProgram() throws IOException {
        this.normalProgram = GL20.glCreateProgram();
        int vshader = Shader.createShader("assets/shaders/shadowMappingShade-vs.glsl", 35633);
        int fshader = Shader.createShader("assets/shaders/shadowMappingShade-fs.glsl", 35632);
        GL20.glAttachShader((int)this.normalProgram, (int)vshader);
        GL20.glAttachShader((int)this.normalProgram, (int)fshader);
        GL20.glBindAttribLocation((int)this.normalProgram, (int)0, (CharSequence)"position");
        GL20.glBindAttribLocation((int)this.normalProgram, (int)1, (CharSequence)"normal");
        GL20.glLinkProgram((int)this.normalProgram);
        int linked = GL20.glGetProgrami((int)this.normalProgram, (int)35714);
        String programLog = GL20.glGetProgramInfoLog((int)this.normalProgram);
        if (programLog.trim().length() > 0) {
            System.err.println(programLog);
        }
        if (linked == 0) {
            throw new AssertionError((Object)"Could not link program");
        }
        this.initNormalProgram();
    }

    public void initNormalProgram() {
        GL20.glUseProgram((int)this.normalProgram);
        this.samplerLocation = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"depthTexture");
        this.normalProgramBiasUniform = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"biasMatrix");
        this.normalProgramVPUniform = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"viewProjectionMatrix");
        this.normalProgramLVPUniform = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"lightViewProjectionMatrix");
        this.normalProgramLightPosition = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"lightPosition");
        this.normalProgramLightLookAt = GL20.glGetUniformLocation((int)this.normalProgram, (CharSequence)"lightLookAt");
        GL20.glUniform1i((int)this.samplerLocation, (int)0);
        GL20.glUseProgram((int)0);
    }

    public int id() {
        return this.normalProgram;
    }

    public int normalProgramBiasUniform() {
        return this.normalProgramBiasUniform;
    }

    public int normalProgramVPUniform() {
        return this.normalProgramVPUniform;
    }

    public int normalProgramLVPUniform() {
        return this.normalProgramLVPUniform;
    }

    public int normalProgramLightPosition() {
        return this.normalProgramLightPosition;
    }

    public int normalProgramLightLookAt() {
        return this.normalProgramLightLookAt;
    }

    public int samplerLocation() {
        return this.samplerLocation;
    }
}

