/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.firelab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.MemoryUtil;

public class Shader {
    private int shadowProgram;
    private String vertexShadeLocation;
    private String fragShaderLocation;

    public Shader(String vertexShader, String fragShader) throws IOException {
        this.vertexShadeLocation = vertexShader;
        this.fragShaderLocation = fragShader;
        this.createShadowProgram();
        this.initShadowProgram();
    }

    public int initShadowProgram() {
        GL20.glUseProgram((int)this.shadowProgram);
        int shadowProgramVPUniform = GL20.glGetUniformLocation((int)this.shadowProgram, (CharSequence)"viewProjectionMatrix");
        GL20.glUseProgram((int)0);
        return shadowProgramVPUniform;
    }

    void createShadowProgram() throws IOException {
        this.shadowProgram = GL20.glCreateProgram();
        int vshader = Shader.createShader(this.vertexShadeLocation, 35633);
        int fshader = Shader.createShader(this.fragShaderLocation, 35632);
        GL20.glAttachShader((int)this.shadowProgram, (int)vshader);
        GL20.glAttachShader((int)this.shadowProgram, (int)fshader);
        GL20.glBindAttribLocation((int)this.shadowProgram, (int)0, (CharSequence)"position");
        GL20.glLinkProgram((int)this.shadowProgram);
        int linked = GL20.glGetProgrami((int)this.shadowProgram, (int)35714);
        String programLog = GL20.glGetProgramInfoLog((int)this.shadowProgram);
        if (programLog.trim().length() > 0) {
            System.err.println(programLog);
        }
        if (linked == 0) {
            throw new AssertionError((Object)"Could not link program");
        }
    }

    public int id() {
        return this.shadowProgram;
    }

    public static int createShader(String resource, int type) throws IOException {
        return Shader.createShader(resource, type, null);
    }

    public static int createShader(String resource, int type, String version) throws IOException {
        IntBuffer lengths;
        PointerBuffer strings;
        int shader = GL20.glCreateShader((int)type);
        ByteBuffer source = Shader.ioResourceToByteBuffer(resource, 8192);
        if (version == null) {
            strings = BufferUtils.createPointerBuffer((int)1);
            lengths = BufferUtils.createIntBuffer((int)1);
            strings.put(0, source);
            lengths.put(0, source.remaining());
            GL20.glShaderSource((int)shader, (PointerBuffer)strings, (IntBuffer)lengths);
        } else {
            strings = BufferUtils.createPointerBuffer((int)2);
            lengths = BufferUtils.createIntBuffer((int)2);
            ByteBuffer preamble = MemoryUtil.memUTF8((CharSequence)("#version " + version + "\n"), (boolean)false);
            strings.put(0, preamble);
            lengths.put(0, preamble.remaining());
            strings.put(1, source);
            lengths.put(1, source.remaining());
            GL20.glShaderSource((int)shader, (PointerBuffer)strings, (IntBuffer)lengths);
        }
        GL20.glCompileShader((int)shader);
        int compiled = GL20.glGetShaderi((int)shader, (int)35713);
        String shaderLog = GL20.glGetShaderInfoLog((int)shader);
        if (shaderLog.trim().length() > 0) {
            System.err.println(shaderLog);
        }
        if (compiled == 0) {
            throw new AssertionError((Object)"Could not compile shader");
        }
        return shader;
    }

    private static ByteBuffer resizeBuffer(ByteBuffer buffer, int newCapacity) {
        ByteBuffer newBuffer = BufferUtils.createByteBuffer((int)newCapacity);
        buffer.flip();
        newBuffer.put(buffer);
        return newBuffer;
    }

    public static ByteBuffer ioResourceToByteBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (url == null) {
            throw new IOException("Classpath resource not found: " + resource);
        }
        File file = new File(url.getFile());
        if (file.isFile()) {
            FileInputStream fis = new FileInputStream(file);
            FileChannel fc = fis.getChannel();
            buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            fc.close();
            fis.close();
        } else {
            buffer = BufferUtils.createByteBuffer((int)bufferSize);
            InputStream source = url.openStream();
            if (source == null) {
                throw new FileNotFoundException(resource);
            }
            try {
                int bytes;
                byte[] buf = new byte[8192];
                while ((bytes = source.read(buf, 0, buf.length)) != -1) {
                    if (buffer.remaining() < bytes) {
                        buffer = Shader.resizeBuffer(buffer, Math.max(buffer.capacity() * 2, buffer.capacity() - buffer.remaining() + bytes));
                    }
                    buffer.put(buf, 0, bytes);
                }
                buffer.flip();
            }
            finally {
                source.close();
            }
        }
        return buffer;
    }
}

