/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src;

import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Game;
import java.util.Map;

public class Entity {
    public static int index = 0;
    public int id = 0;
    public float x = 0.0f;
    public float y = 0.0f;
    public float forceX = 0.0f;
    public float forceY = 0.0f;
    public float width = 1.0f;
    public float height = 1.0f;
    public float slipperiness = 0.99999f;
    public boolean noAI = false;
    public boolean hitGround = false;
    public boolean useHitbox = true;
    public boolean useGravity = true;
    public int team = 0;
    public int collideType = 0;
    public boolean takeDamage = true;
    public boolean damageDelt = false;
    public int health = 5;
    public int damage = 1;
    public int mass = 1;
    public boolean dead = false;
    public float damageTime = 0.0f;

    public Entity(float _x, float _y) {
        this.x = _x;
        this.y = _y;
        this.id = index++;
    }

    public void tick() {
        this.damageDelt = false;
        if (!this.noAI && !this.dead) {
            for (Map.Entry<String, Entity> entity : Game.entities.entrySet()) {
                Entity _object = entity.getValue();
                if (_object.id == this.id || !_object.useHitbox || _object.dead) continue;
                float largestValue = 0.0f;
                largestValue = Tools.setSmallest(largestValue, this.width);
                largestValue = Tools.setSmallest(largestValue, this.height);
                largestValue = Tools.setSmallest(largestValue, _object.width);
                largestValue = Tools.setSmallest(largestValue, _object.height);
                if (!(Tools.distance(this.x, this.y, _object.x, _object.y) < largestValue / 2.0f)) continue;
                if (_object.team == 1 && this.team == 2 || _object.team == 2 && this.team == 1 || _object.team == 0 && this.team == 1 || _object.team == 0 && this.team == 0) {
                    double angle = Math.atan2(_object.y - this.y, _object.x - this.x);
                    double dx = Math.cos(angle) * 2.0;
                    double dy = Math.sin(angle) * 2.0;
                    if (_object.team == 2) {
                        dx /= (double)this.mass;
                        dy /= (double)this.mass;
                    }
                    this.forceX = (float)((double)this.forceX - dx);
                    this.forceY = (float)((double)this.forceY - dy);
                    if ((_object.team != 1 || this.team != 2) && (_object.team != 2 || this.team != 1)) continue;
                    this.damageDelt = _object.damage(this.damage);
                    continue;
                }
                if (_object.team == 1 && this.team == 1 || _object.team == 2 && this.team == 2 || _object.team == 0 && this.team == 2 || _object.team == 2 && this.team == 0) continue;
                this.damageDelt = _object.damage(this.damage);
            }
            if (this.health <= 0) {
                this.remove();
            }
            this.x += this.forceX * (Game.deltaTime / 1000.0f);
            this.y += this.forceY * (Game.deltaTime / 1000.0f);
            this.forceX *= this.slipperiness;
            this.forceY *= this.slipperiness;
            if ((double)this.forceX < 1.0E-6 && (double)this.forceX > -1.0E-6) {
                this.forceX = 0.0f;
            }
            if ((double)this.forceY < 1.0E-6 && (double)this.forceY > -1.0E-6) {
                this.forceY = 0.0f;
            }
            if (this.y - this.height / 2.0f > Game.floor) {
                if (this.useGravity) {
                    this.forceY = (float)((double)this.forceY - 0.095 * (double)(Game.deltaTime / 10.0f));
                    this.slipperiness = 0.99999f;
                }
            } else {
                this.y = Game.floor + this.height / 2.0f;
                this.forceY = 0.0f;
                this.hitGround = true;
                this.slipperiness = 0.5f;
            }
            if (this.damageTime > 0.0f) {
                this.damageTime -= Game.deltaTime / 1000.0f;
            }
        }
    }

    public void render() {
    }

    public boolean damage(int damage) {
        boolean bool = false;
        if (damage > 0 && this.damageTime <= 0.0f) {
            this.health -= damage;
            this.damageTime = 0.3f;
            bool = true;
        }
        return bool;
    }

    public void remove() {
        this.dead = true;
    }
}

