/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.Text;
import com.arizotaz.core.menus.Debug;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.core.ui.Button;
import com.arizotaz.core.window.KeyboardInput;
import com.arizotaz.core.window.Mouse;
import com.arizotaz.src.Engine;
import com.arizotaz.src.Entity;
import com.arizotaz.src.Slot;
import com.arizotaz.src.UI;
import com.arizotaz.src.Wave;
import com.arizotaz.src.entites.Arrow;
import com.arizotaz.src.entites.Boulder;
import com.arizotaz.src.entites.EnemyCatapult;
import com.arizotaz.src.entites.EnemyKnight;
import com.arizotaz.src.entites.EnemyShield;
import com.arizotaz.src.entites.Knight;
import com.arizotaz.src.entites.Mine;
import com.arizotaz.src.entites.SpikedWall;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;

public class Game {
    public static HashMap<String, Slot> slots;
    public static HashMap<String, Entity> entities;
    public static float deltaTime;
    private static long last_time;
    public static float floor;
    public int slotID = 0;
    public static boolean allowSpawn;
    public static boolean _allowSpawn;
    public float spawnTimer = 0.0f;
    public static int coins;
    public static int lives;
    public static int oglives;
    public static int level;
    public int lastEnemies = 0;
    boolean slotDown = true;
    Button waveButton = new Button();

    static {
        deltaTime = 0.0f;
        last_time = System.nanoTime();
        floor = -8.0f;
        allowSpawn = false;
        _allowSpawn = false;
        coins = 0;
        lives = 0;
        oglives = 1;
        level = 0;
    }

    public static void reset() {
        slots = new HashMap();
        entities = new HashMap();
        Engine.game.slotID = 0;
        Engine.game.spawnTimer = 2.0f;
        coins = 10;
        lives = 50;
        oglives = 50;
        level = 0;
        Slot slot = new Slot("0", 0, "bowarrow", 0.2f, 20, 1);
        slots.put(slot.name, slot);
        Game.slots.get((Object)"0").purchaseAmount = 5;
        slot = new Slot("1", 1, "spiked_wall", 0.5f, 0, 12);
        slots.put(slot.name, slot);
        slot = new Slot("2", 2, "mine", 1.0f, 0, 50);
        slots.put(slot.name, slot);
        slot = new Slot("3", 3, "boulder", 1.0f, 0, 140);
        slots.put(slot.name, slot);
        slot = new Slot("4", 4, "knight", 0.1f, 0, 5);
        slots.put(slot.name, slot);
        slot = new Slot("5", 5, "cannon", 1.0f, 0, 200);
        slots.put(slot.name, slot);
    }

    public void start() {
        Game.reset();
        entities.put(String.valueOf(Entity.index), new EnemyCatapult(-21.0f, -6.0f));
        int i = 0;
        while (i < 150) {
            entities.put(String.valueOf(Entity.index), new EnemyKnight(Tools.clampVar((float)(-Math.random()) * 300.0f - 21.0f, -300.0f, -21.0f), -6.0f));
            ++i;
        }
        i = 0;
        while (i < 50) {
            entities.put(String.valueOf(Entity.index), new EnemyShield(Tools.clampVar((float)(-Math.random()) * 300.0f - 21.0f, -300.0f, -21.0f), -6.0f));
            ++i;
        }
        RenderObjects.useMaps = true;
    }

    public void tick() {
        Slot slot;
        Options.setTranslate(Options.widthOfScreen / 2.0f, Options.heightOfScreen / 2.0f);
        if (KeyboardInput.isKeyDown(80)) {
            lives = 0;
        }
        if (Wave.enemies <= 0 && this.lastEnemies > 0) {
            ++level;
        }
        this.lastEnemies = Wave.enemies;
        try {
            for (Map.Entry<String, Entity> me : entities.entrySet()) {
                me.getValue().tick();
            }
        }
        catch (ConcurrentModificationException me) {
            // empty catch block
        }
        if (UI.index == 0) {
            if (this.spawnTimer <= 0.0f) {
                slot = slots.get(String.valueOf(this.slotID));
                if (Mouse.left && allowSpawn && slot.amount > 0) {
                    this.spawnTimer = slot.timeOut;
                    Game.placeEntity(slot.itemId, (float)(Mouse.x - (double)Options.translateX) / Options.scl, (float)(-(Mouse.y - (double)Options.translateY)) / Options.scl);
                    --slot.amount;
                }
            } else {
                this.spawnTimer -= deltaTime / 1000.0f;
            }
            if (lives <= 0) {
                UI.index = 5;
            }
            if (KeyboardInput.isKeyDown(83)) {
                UI.index = 4;
            }
        }
        if (this.slotID == 3) {
            if (Game.slots.get((Object)String.valueOf((int)this.slotID)).amount > 0) {
                entities.put(String.valueOf(Entity.index), new Boulder(17.0f, -5.0f, -10.0f, 5.0f));
                slot = slots.get(String.valueOf(this.slotID));
                --slot.amount;
                this.slotID = 0;
            } else {
                this.slotID = 0;
            }
        }
        ArrayList<String> idsToRemove = new ArrayList<String>();
        try {
            for (Map.Entry<String, Entity> me : entities.entrySet()) {
                if (!me.getValue().dead) continue;
                idsToRemove.add(me.getKey());
            }
        }
        catch (Exception me) {
            // empty catch block
        }
        int i = 0;
        while ((float)i < Tools.setLargest(idsToRemove.size(), 10.0f)) {
            entities.remove(idsToRemove.get(i));
            ++i;
        }
    }

    public void render() {
        Debug.Fields.put("Entities", entities.size());
        Debug.Fields.put("Wave", level);
        floor = -7.0f;
        _allowSpawn = true;
        RenderObjects.setColor(222.0f, 251.0f, 255.0f);
        RenderObjects.drawRect(0.0f, 0.0f, Options.widthOfScreen, Options.heightOfScreen, 0.0f);
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImage("background", 0.0f, 0.0f, Options.widthOfScreen, Options.widthOfScreen, 0.0f);
        try {
            for (Map.Entry<String, Entity> me : entities.entrySet()) {
                if (me.getValue().dead) continue;
                me.getValue().render();
            }
        }
        catch (ConcurrentModificationException me) {
            // empty catch block
        }
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImage("ground", 0.0f, floor * Options.scl - Options.scl, 40.0f * Options.scl, Options.scl * 40.0f, 0.0f);
        float castleSize = Options.scl * 8.0f;
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImage("castle", Options.scl * 16.0f, -Options.scl * 3.0f, castleSize, castleSize, 0.0f);
        if (UI.index == 0) {
            if (this.slotID == 0) {
                this.renderArrowTrag();
            }
            this.ui();
        }
        allowSpawn = _allowSpawn;
    }

    public void ui() {
        if (Wave.enemies <= 0) {
            this.waveButton.Set("Start New Wave", 0.0f, (int)Options.scl * -8, (int)Options.scl * 12, (int)Options.scl);
            this.waveButton.Render();
            if (this.waveButton.IsHovering()) {
                _allowSpawn = false;
            }
            if (this.waveButton.IsClicked()) {
                Wave.spawn(level);
            }
        }
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImage("coin", -Options.widthOfScreen / 2.0f + Options.scl / 4.0f, Options.heightOfScreen / 2.0f - Options.scl / 4.0f, Options.scl / 2.0f, Options.scl / 2.0f, 0.0f);
        Text.render(String.valueOf(coins) + " Coins", -Options.widthOfScreen / 2.0f + Options.scl / 4.0f + Options.scl / 2.0f, Options.heightOfScreen / 2.0f - Options.scl / 8.0f, Options.scl / 3.0f, 1000, Text.left);
        Text.render("Wave: " + level, -Options.widthOfScreen / 2.0f, Options.heightOfScreen / 2.0f - 24.0f, 12.0f, 100, Text.left);
        Text.render("Entities: " + entities.size(), -Options.widthOfScreen / 2.0f, Options.heightOfScreen / 2.0f - 48.0f, 12.0f, 100, Text.left);
        if (oglives != 0) {
            Text.render("integrity " + (int)((float)lives / (float)oglives * 100.0f) + "%", Options.scl * 16.0f, 0.0f, 12.0f, 100, Text.center);
        }
        RenderObjects.setColor(0.0f, 0.0f, 0.0f, 150.0f);
        RenderObjects.drawRect(0.0f, Options.heightOfScreen / 2.0f - Options.scl, Options.scl * 20.0f, (int)((double)Options.scl * 1.5), 0.0f);
        if (Mouse.x - (double)Options.translateX > (double)(-(Options.scl * 20.0f) / 2.0f) && Mouse.x - (double)Options.translateX < (double)(Options.scl * 20.0f / 2.0f) && Mouse.y - (double)Options.translateY < (double)(-Options.heightOfScreen / 2.0f + Options.scl) + (double)Options.scl * 1.5 / 2.0 && Mouse.y - (double)Options.translateY > (double)(-Options.heightOfScreen / 2.0f + Options.scl) - (double)Options.scl * 1.5 / 2.0) {
            _allowSpawn = false;
        }
        float x = 0.0f;
        float y = Options.heightOfScreen / 2.0f - Options.scl;
        int index = -6;
        for (Map.Entry<String, Slot> me : slots.entrySet()) {
            boolean hover = false;
            if (Mouse.x - (double)Options.translateX < (double)x + (double)index * ((double)Options.scl * 1.5) + (double)Options.scl * 1.2 / 2.0 && Mouse.x - (double)Options.translateX > (double)x + (double)index * ((double)Options.scl * 1.5) - (double)Options.scl * 1.2 / 2.0 && Mouse.y - (double)Options.translateY < (double)(-y) + (double)Options.scl * 1.2 / 2.0 && Mouse.y - (double)Options.translateY > (double)(-y) - (double)Options.scl * 1.2 / 2.0) {
                hover = true;
                if (Mouse.clicked) {
                    this.slotID = Integer.parseInt(me.getKey());
                }
            }
            RenderObjects.setColor(0.0f, 0.0f, 0.0f, 100.0f);
            if (hover) {
                RenderObjects.setColor(255.0f, 255.0f, 255.0f, 200.0f);
            }
            RenderObjects.drawRoundedRect((int)((double)x + (double)index * ((double)Options.scl * 1.5)), y, 0.0, (double)Options.scl * 1.2, (double)Options.scl * 1.2, 10.0, 3);
            RenderObjects.setColor(255.0f, 255.0f, 255.0f, 100.0f);
            if (hover) {
                RenderObjects.setColor(255.0f, 255.0f, 255.0f, 255.0f);
            }
            RenderObjects.drawImage(me.getValue().texture, (int)((double)x + (double)index * ((double)Options.scl * 1.5)), y, Options.scl, Options.scl, 0.0f);
            RenderObjects.setColor(255.0f);
            Text.render(String.valueOf(me.getValue().amount), (int)((double)x + (double)index * ((double)Options.scl * 1.5)), y, Options.scl / 3.0f, 100, Text.center);
            ++index;
        }
    }

    public static void placeEntity(int _id, float _x, float _y) {
        switch (_id) {
            case 0: {
                entities.put(String.valueOf(Entity.index), new Arrow(_x, _y));
                break;
            }
            case 1: {
                entities.put(String.valueOf(Entity.index), new SpikedWall(_x, _y));
                break;
            }
            case 2: {
                entities.put(String.valueOf(Entity.index), new Mine(_x, _y));
                break;
            }
            case 4: {
                entities.put(String.valueOf(Entity.index), new Knight(_x, _y));
            }
        }
    }

    public void renderArrowTrag() {
        Arrow.startX = Options.scl * 14.5f;
        Arrow.startY = -Options.scl * 4.7f;
        Arrow.publicDistance = Tools.distance(0.0f, 0.0f, (float)(Mouse.x - (double)Options.translateX - (double)Arrow.startX) / Options.scl, (float)(Mouse.y - (double)Options.translateY + (double)Arrow.startY) / Options.scl);
        float i = 0.0f;
        while (i < 40.0f) {
            float _y = Arrow.getArrowTrag(i, Arrow.publicDistance);
            if (_y > -5.0f) {
                RenderObjects.drawRect(-i * Options.scl + Arrow.startX, _y * Options.scl + Arrow.startY, Options.scl / 8.0f, Options.scl / 8.0f, 0.0f);
            }
            i += 1.0f;
        }
    }
}

