/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src.entites;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Entity;
import com.arizotaz.src.Game;

public class Arrow
extends Entity {
    public static float startX = 0.0f;
    public static float startY = 0.0f;
    public static float publicDistance = 0.0f;
    float distance = publicDistance;
    float toX = 0.0f;
    float toY = 0.0f;
    float timer = 20.0f;

    public Arrow(float _x, float _y) {
        super(_x, _y);
        this.toX = _x;
        this.toY = 0.0f;
        this.x = startX / Options.scl;
        this.y = startY / Options.scl;
        this.width = 0.3f;
        this.height = 0.3f;
        this.forceX = -15.0f;
        this.useHitbox = false;
        this.damage = 3;
    }

    @Override
    public void tick() {
        if (!this.noAI) {
            this.y = Arrow.getArrowTrag(startX / Options.scl - this.x, this.distance) - 5.0f;
        }
        super.tick();
        if (this.hitGround) {
            this.noAI = true;
        }
        if (this.noAI) {
            this.timer -= Game.deltaTime / 1000.0f;
            if (this.timer <= 0.0f) {
                this.remove();
            }
        }
        if (this.damageDelt) {
            this.remove();
        }
    }

    @Override
    public void render() {
        super.render();
        float _x = this.x - 1.0f;
        float _y = Arrow.getArrowTrag(startX / Options.scl - _x, this.distance) - 5.0f;
        double angle = Math.atan2(this.y - _y, this.x - _x);
        float rotation = (float)Math.toDegrees(angle) + 0.0f;
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImage("arrow", this.x * Options.scl, this.y * Options.scl, Options.scl / 2.0f, Options.scl / 2.0f, rotation);
    }

    public static float getArrowTrag(float _x, float distance) {
        float d = Tools.clampVar(distance, 0.0f, 25.0f) / 8.0f;
        float a = 1.0f;
        return (float)((double)(d * _x) - 0.5 * (double)a * (double)(_x * _x / 4.0f));
    }
}

