/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src.entites;

import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Entity;
import com.arizotaz.src.Game;
import com.arizotaz.src.Wave;
import com.arizotaz.src.entites.Coin;

public class Enemy
extends Entity {
    public boolean drops = true;
    public int minCoinDrop = 5;
    public int maxCoinDrop = 10;

    public Enemy(float _x, float _y) {
        super(_x, _y);
        this.team = 1;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.x > 14.0f) {
            Game.lives -= this.damage;
            this.drops = false;
            this.remove();
        }
    }

    @Override
    public void render() {
        super.render();
    }

    @Override
    public void remove() {
        if (!this.dead) {
            if (this.drops) {
                float amount = Math.round(Math.random() * (double)this.maxCoinDrop);
                amount = Tools.clampVar(amount, this.minCoinDrop, this.maxCoinDrop);
                int i = 0;
                while ((float)i < amount) {
                    float forceX = (float)Math.random() * 10.0f - 5.0f;
                    float forceY = (float)Math.random() * 5.0f;
                    Game.entities.put(String.valueOf(Entity.index), new Coin(this.x, this.y, forceX, forceY));
                    ++i;
                }
            }
            --Wave.enemies;
        }
        super.remove();
    }
}

