/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src.entites;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Game;
import com.arizotaz.src.entites.Enemy;
import com.arizotaz.src.entites.EnemyFireRock;

public class EnemyCatapult
extends Enemy {
    public float speed = Tools.clampVar((float)(Math.random() * 3.0 + 2.5), 3.0f, 4.0f);
    public int spriteY = 0;
    public float lastSpriteX = 0.0f;
    public float lastSpriteY = 0.0f;
    public float shootTimer = 0.0f;
    public boolean aniUp = true;

    public EnemyCatapult(float _x, float _y) {
        super(_x, _y);
        this.damage = 60;
        this.health = 50;
        this.width = 3.0f;
        this.height = 1.0f;
        this.minCoinDrop = 15;
        this.maxCoinDrop = 40;
        this.mass = 2;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.hitGround) {
            this.slipperiness = 0.95f;
            if (this.x < 2.0f) {
                this.forceX += Game.deltaTime / 1000.0f * this.speed;
                if ((double)Tools.distance(this.x, this.y, this.lastSpriteX, this.lastSpriteY) > 0.2) {
                    this.lastSpriteX = this.x;
                    this.lastSpriteY = this.y;
                    ++this.spriteY;
                    if (this.spriteY > 1) {
                        this.spriteY = 0;
                    }
                }
            } else {
                if (this.spriteY <= 1) {
                    this.spriteY = 1;
                }
                this.shootTimer += Game.deltaTime / 1000.0f;
                if (this.aniUp) {
                    if (this.shootTimer > 2.0f && this.spriteY == 1 || (double)this.shootTimer > 0.5 && this.spriteY == 2 || this.shootTimer > 2.0f && this.spriteY == 3) {
                        this.shootTimer = 0.0f;
                        ++this.spriteY;
                        if (this.spriteY >= 3) {
                            this.aniUp = false;
                            Game.entities.put(String.valueOf(index), new EnemyFireRock(this.x, this.y + 2.0f, 10.0f, 4.0f));
                        }
                    }
                } else if (this.shootTimer > 2.0f && this.spriteY == 1 || (double)this.shootTimer > 0.5 && this.spriteY == 2 || this.shootTimer > 2.0f && this.spriteY == 3) {
                    this.shootTimer = 0.0f;
                    --this.spriteY;
                    if (this.spriteY <= 1) {
                        this.aniUp = true;
                    }
                }
            }
        }
    }

    @Override
    public void render() {
        super.render();
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImageFromSheet("enemies", this.x * Options.scl, (this.y + this.width / 3.0f) * Options.scl, Options.scl * this.width, Options.scl * this.width, 7.0f, this.spriteY, 8.0f, 8, 0.0f);
    }
}

