/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src.entites;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Game;
import com.arizotaz.src.entites.Enemy;
import com.arizotaz.src.entites.EnemySpell;

public class EnemyMage
extends Enemy {
    public float speed = 0.1f;
    public int spriteX = 1;
    public float lastSpriteX = 0.0f;
    public float lastSpriteY = 0.0f;
    public float target = 0.0f;
    public float shootTimer = 4.0f;

    public EnemyMage(float _x, float _y) {
        super(_x, _y);
        this.damage = 20;
        this.health = 5;
        this.target = Tools.clampVar((float)(Math.random() * 16.0 - 8.0), -8.0f, 8.0f);
        this.minCoinDrop = 20;
        this.maxCoinDrop = 35;
    }

    @Override
    public void tick() {
        super.tick();
        if ((double)Tools.distance(this.x, this.y, this.lastSpriteX, this.lastSpriteY) > 0.2) {
            this.lastSpriteX = this.x;
            this.lastSpriteY = this.y;
            ++this.spriteX;
            if (this.spriteX > 3) {
                this.spriteX = 0;
            }
        }
        this.slipperiness = 0.97f;
        this.speed = this.x < -22.0f ? 0.5f : 0.03f;
        if (this.x >= this.target) {
            if (this.shootTimer <= 0.0f) {
                Game.entities.put(String.valueOf(index), new EnemySpell(this.x, this.y + 0.5f, 10.0f, 0.2f));
                this.shootTimer = 1.0f;
            } else {
                this.shootTimer -= Game.deltaTime / 1000.0f;
            }
        } else if (this.hitGround && !this.noAI) {
            this.forceX += this.speed;
        }
    }

    @Override
    public void render() {
        super.render();
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImageFromSheet("enemies", this.x * Options.scl, this.y * Options.scl, Options.scl, Options.scl, this.spriteX, 1.0f, 16.0f, 16, 0.0f);
    }
}

