/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.src.entites;

import com.arizotaz.core.Options;
import com.arizotaz.core.RenderObjects;
import com.arizotaz.core.tools.Tools;
import com.arizotaz.src.Wave;
import com.arizotaz.src.entites.Friendly;

public class Knight
extends Friendly {
    public float speed = Tools.clampVar(this.speed, 0.3f, 1.2f);
    public int spriteX = 1;
    public float lastSpriteX = 0.0f;
    public float lastSpriteY = 0.0f;

    public Knight(float _x, float _y) {
        super(_x, _y);
        this.damage = (int)Math.ceil(Math.random() * 4.0);
        this.health = 5;
    }

    @Override
    public void tick() {
        super.tick();
        if (Wave.enemies > 0) {
            if (this.hitGround && !this.noAI) {
                this.forceX -= this.speed;
            }
            if ((double)Tools.distance(this.x, this.y, this.lastSpriteX, this.lastSpriteY) > 0.2) {
                this.lastSpriteX = this.x;
                this.lastSpriteY = this.y;
                ++this.spriteX;
                if (this.spriteX > 3) {
                    this.spriteX = 0;
                }
            }
        }
    }

    @Override
    public void render() {
        super.render();
        RenderObjects.setColor(255.0f);
        RenderObjects.drawImageFromSheet("enemies", this.x * Options.scl, this.y * Options.scl, -Options.scl, Options.scl, this.spriteX, 0.0f, 16.0f, 16, 0.0f);
    }
}

