/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.zeronox;

import com.arizotaz.core.reqs.BufferUtilities;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.openal.AL10;
import org.lwjgl.stb.STBVorbis;
import org.lwjgl.stb.STBVorbisInfo;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class SoundBuffer {
    private final int bufferId = AL10.alGenBuffers();
    private ShortBuffer pcm = null;
    private ByteBuffer vorbis = null;

    public SoundBuffer(String file) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (STBVorbisInfo info = STBVorbisInfo.malloc();){
            ShortBuffer pcm = this.readVorbis(file, 32768, info);
            AL10.alBufferData((int)this.bufferId, (int)(info.channels() == 1 ? 4353 : 4355), (ShortBuffer)pcm, (int)info.sample_rate());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public int getBufferId() {
        return this.bufferId;
    }

    public void cleanup() {
        AL10.alDeleteBuffers((int)this.bufferId);
        if (this.pcm != null) {
            MemoryUtil.memFree((Buffer)this.pcm);
        }
    }

    private ShortBuffer readVorbis(String resource, int bufferSize, STBVorbisInfo info) throws Exception {
        Throwable throwable = null;
        Object var5_6 = null;
        try (MemoryStack stack = MemoryStack.stackPush();){
            this.vorbis = BufferUtilities.ioResourceToByteBuffer(resource, bufferSize);
            IntBuffer error = stack.mallocInt(1);
            long decoder = STBVorbis.stb_vorbis_open_memory((ByteBuffer)this.vorbis, (IntBuffer)error, null);
            if (decoder == 0L) {
                throw new RuntimeException("Failed to open Ogg Vorbis file. Error: " + error.get(0));
            }
            STBVorbis.stb_vorbis_get_info((long)decoder, (STBVorbisInfo)info);
            int channels = info.channels();
            int lengthSamples = STBVorbis.stb_vorbis_stream_length_in_samples((long)decoder);
            this.pcm = MemoryUtil.memAllocShort((int)lengthSamples);
            this.pcm.limit(STBVorbis.stb_vorbis_get_samples_short_interleaved((long)decoder, (int)channels, (ShortBuffer)this.pcm) * channels);
            STBVorbis.stb_vorbis_close((long)decoder);
            return this.pcm;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

