/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.zeronox;

import com.arizotaz.zeronox.SoundBuffer;
import com.arizotaz.zeronox.SoundListener;
import com.arizotaz.zeronox.SoundSource;
import java.util.HashMap;
import java.util.Map;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;

public class SoundManager {
    private long device;
    private long context;
    private SoundListener listener;
    private final Map<String, SoundBuffer> soundBufferList = new HashMap<String, SoundBuffer>();
    private final Map<String, SoundSource> soundSourceMap = new HashMap<String, SoundSource>();
    private final Matrix4f cameraMatrix = new Matrix4f();

    public void init() throws Exception {
        this.device = ALC10.alcOpenDevice(null);
        if (this.device == 0L) {
            throw new IllegalStateException("Failed to open the default OpenAL device.");
        }
        ALCCapabilities deviceCaps = ALC.createCapabilities((long)this.device);
        this.context = ALC10.alcCreateContext((long)this.device, null);
        if (this.context == 0L) {
            throw new IllegalStateException("Failed to create OpenAL context.");
        }
        ALC10.alcMakeContextCurrent((long)this.context);
        AL.createCapabilities((ALCCapabilities)deviceCaps);
    }

    public void addSoundSource(String name, SoundSource soundSource) {
        this.soundSourceMap.put(name, soundSource);
    }

    public SoundSource getSoundSource(String name) {
        return this.soundSourceMap.get(name);
    }

    public SoundBuffer getSoundBuffer(String id) {
        return this.soundBufferList.get(id);
    }

    public void playSoundSource(String name) {
        SoundSource soundSource = this.soundSourceMap.get(name);
        if (soundSource != null && !soundSource.isPlaying()) {
            soundSource.play();
        }
    }

    public void playSoundSourceOverlap(String name) {
        SoundSource soundSource = this.soundSourceMap.get(name);
        if (soundSource != null) {
            soundSource.play();
        }
    }

    public void pauseSoundSource(String name) {
        SoundSource soundSource = this.soundSourceMap.get(name);
        if (soundSource != null) {
            soundSource.pause();
        }
    }

    public void stopSoundSource(String name) {
        SoundSource soundSource = this.soundSourceMap.get(name);
        if (soundSource != null) {
            soundSource.stop();
        }
    }

    public void removeSoundSource(String name) {
        this.soundSourceMap.remove(name);
    }

    public void addSoundBuffer(String id, SoundBuffer soundBuffer) {
        this.soundBufferList.put(id, soundBuffer);
    }

    public SoundListener getListener() {
        return this.listener;
    }

    public void setListener(SoundListener listener) {
        this.listener = listener;
    }

    public void updateListenerPosition(Vector3f position) {
        this.listener.setPosition(position);
        Vector3f at = new Vector3f();
        this.cameraMatrix.positiveZ(at).negate();
        Vector3f up = new Vector3f();
        this.cameraMatrix.positiveY(up);
        this.listener.setOrientation(at, up);
    }

    public void setAttenuationModel(int model) {
        AL10.alDistanceModel((int)model);
    }

    public void cleanup() {
        for (SoundSource soundSource : this.soundSourceMap.values()) {
            soundSource.cleanup();
        }
        this.soundSourceMap.clear();
        for (SoundBuffer soundBuffer : this.soundBufferList.values()) {
            soundBuffer.cleanup();
        }
        this.soundBufferList.clear();
        if (this.context != 0L) {
            ALC10.alcDestroyContext((long)this.context);
        }
        if (this.device != 0L) {
            ALC10.alcCloseDevice((long)this.device);
        }
    }
}

