/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.zeronox;

import org.joml.Vector3f;
import org.lwjgl.openal.AL10;

public class SoundSource {
    private final int sourceId = AL10.alGenSources();

    public SoundSource(boolean loop, boolean relative) {
        if (loop) {
            AL10.alSourcei((int)this.sourceId, (int)4103, (int)1);
        }
        if (relative) {
            AL10.alSourcei((int)this.sourceId, (int)514, (int)1);
        }
    }

    public void setBuffer(int bufferId) {
        this.stop();
        AL10.alSourcei((int)this.sourceId, (int)4105, (int)bufferId);
    }

    public void setPosition(Vector3f position) {
        AL10.alSource3f((int)this.sourceId, (int)4100, (float)position.x, (float)position.y, (float)position.z);
    }

    public void setSpeed(Vector3f speed) {
        AL10.alSource3f((int)this.sourceId, (int)4102, (float)speed.x, (float)speed.y, (float)speed.z);
    }

    public void setGain(float gain) {
        AL10.alSourcef((int)this.sourceId, (int)4106, (float)gain);
    }

    public void setProperty(int param, float value) {
        AL10.alSourcef((int)this.sourceId, (int)param, (float)value);
    }

    public void play() {
        AL10.alSourcePlay((int)this.sourceId);
    }

    public boolean isPlaying() {
        return AL10.alGetSourcei((int)this.sourceId, (int)4112) == 4114;
    }

    public void pause() {
        AL10.alSourcePause((int)this.sourceId);
    }

    public void stop() {
        AL10.alSourceStop((int)this.sourceId);
    }

    public void cleanup() {
        this.stop();
        AL10.alDeleteSources((int)this.sourceId);
    }
}

