/*
 * Decompiled with CFR 0.152.
 */
package com.arizotaz.zeronox;

import com.arizotaz.zeronox.SoundBuffer;
import com.arizotaz.zeronox.SoundListener;
import com.arizotaz.zeronox.SoundManager;
import com.arizotaz.zeronox.SoundSource;
import java.util.ArrayList;
import org.joml.Vector3f;

public class Zeronox {
    private static SoundManager soundMgr;
    private static ArrayList<String> removeSounds;

    static {
        removeSounds = new ArrayList();
    }

    public static void init() {
        try {
            soundMgr = new SoundManager();
            soundMgr.init();
            soundMgr.setAttenuationModel(53253);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        soundMgr = new SoundManager();
        Zeronox.ListenerLocation(0.0f, 0.0f, 0.0f);
    }

    public static void update() {
        ArrayList<String> r = new ArrayList<String>();
        int i = 0;
        while (i < removeSounds.size()) {
            if (!soundMgr.getSoundSource(removeSounds.get(i)).isPlaying()) {
                r.add(removeSounds.get(i));
            }
            ++i;
        }
        i = 0;
        while (i < r.size()) {
            int s = 0;
            while (s < removeSounds.size()) {
                if (r.get(i) == removeSounds.get(s)) {
                    removeSounds.remove(s);
                }
                ++s;
            }
            ++i;
        }
    }

    public static void ListenerLocation(float x, float y, float z) {
        soundMgr.setListener(new SoundListener(new Vector3f(x, y, z)));
    }

    public static String add(String id, String fileLocation) {
        return Zeronox.add(id, fileLocation, false);
    }

    public static String add(String id, String fileLocation, boolean keep) {
        try {
            SoundBuffer buffer;
            if (!fileLocation.startsWith("/")) {
                fileLocation = "/" + fileLocation;
            }
            if ((buffer = soundMgr.getSoundBuffer(id)) == null) {
                buffer = new SoundBuffer(fileLocation);
            }
            soundMgr.addSoundBuffer(id, buffer);
            if (keep) {
                id = String.valueOf(id) + String.valueOf(Math.round(Math.random() * 100000.0));
                SoundSource sourceBeep = new SoundSource(false, false);
                sourceBeep.setBuffer(buffer.getBufferId());
                soundMgr.addSoundSource(id, sourceBeep);
            }
            System.out.println("Loaded " + id);
        }
        catch (Exception e) {
            System.out.println("Could not load sound:" + id);
            e.printStackTrace();
        }
        return id;
    }

    public static void Play(String id) {
        soundMgr.playSoundSource(id);
    }

    public static void PlayKeep(String id, float x, float y, float z) {
        SoundSource sound = soundMgr.getSoundSource(id);
        if (sound != null) {
            sound.setPosition(new Vector3f(x, y, z));
            soundMgr.playSoundSource(id);
        } else {
            System.err.println("Sound " + id + " does not exist");
        }
    }

    public static void Play(String id, float x, float y, float z) {
        Zeronox.PlayKeep(id, x, y, z);
    }

    public static void Pause(String id) {
        soundMgr.pauseSoundSource(id);
    }

    public static void Stop(String id) {
        soundMgr.stopSoundSource(id);
    }
}

